/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.Lshw;
import oshi.driver.linux.proc.CpuStat;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.LinuxLibc;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.GlobalConfig;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
final class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final String CPUFREQ_PATH = "oshi.cpu.freq.path";

    LinuxCentralProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final CentralProcessor.ProcessorIdentifier queryProcessorId() {
        void var3_3;
        void var2_2;
        void var1_1;
        String cpuVendor = "";
        String cpuName = "";
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        long cpuFreq = 0L;
        boolean cpu64bit = false;
        StringBuilder armStepping = new StringBuilder();
        String[] flags = new String[]{};
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        for (String line : list) {
            String[] splitLine = ParseUtil.whitespacesColonWhitespace.split(line);
            if (splitLine.length < 2) {
                if (!line.startsWith("CPU architecture: ")) continue;
                cpuFamily = line.replace("CPU architecture: ", "").trim();
                continue;
            }
            String string = splitLine[0];
            int n = -1;
            switch (string.hashCode()) {
                case -1085970574: {
                    if (!string.equals("vendor_id")) break;
                    n = 0;
                    break;
                }
                case -1509145992: {
                    if (!string.equals("CPU implementer")) break;
                    n = 1;
                    break;
                }
                case 2046689570: {
                    if (!string.equals("model name")) break;
                    n = 2;
                    break;
                }
                case 909208690: {
                    if (!string.equals("Processor")) break;
                    n = 3;
                    break;
                }
                case 97513095: {
                    if (!string.equals("flags")) break;
                    n = 4;
                    break;
                }
                case 1429357118: {
                    if (!string.equals("stepping")) break;
                    n = 5;
                    break;
                }
                case -1815500307: {
                    if (!string.equals("CPU variant")) break;
                    n = 6;
                    break;
                }
                case 542854003: {
                    if (!string.equals("CPU revision")) break;
                    n = 7;
                    break;
                }
                case 104069929: {
                    if (!string.equals("model")) break;
                    n = 8;
                    break;
                }
                case 1256489867: {
                    if (!string.equals("CPU part")) break;
                    n = 9;
                    break;
                }
                case 547394780: {
                    if (!string.equals("cpu family")) break;
                    n = 10;
                    break;
                }
                case 984097735: {
                    if (!string.equals("cpu MHz")) break;
                    n = 11;
                }
            }
            block14 : switch (n) {
                case 0: 
                case 1: {
                    cpuVendor = splitLine[1];
                    break;
                }
                case 2: 
                case 3: {
                    cpuName = splitLine[1];
                    break;
                }
                case 4: {
                    flags = splitLine[1].toLowerCase().split(" ");
                    splitLine = flags;
                    int n2 = flags.length;
                    for (n = 0; n < n2; ++n) {
                        String flag = splitLine[n];
                        if (!"lm".equals(flag)) continue;
                        cpu64bit = true;
                        break block14;
                    }
                    break;
                }
                case 5: {
                    cpuStepping = splitLine[1];
                    break;
                }
                case 6: {
                    if (armStepping.toString().startsWith("r")) break;
                    armStepping.insert(0, "r" + splitLine[1]);
                    break;
                }
                case 7: {
                    if (armStepping.toString().contains("p")) break;
                    armStepping.append('p').append(splitLine[1]);
                    break;
                }
                case 8: 
                case 9: {
                    cpuModel = splitLine[1];
                    break;
                }
                case 10: {
                    cpuFamily = splitLine[1];
                    break;
                }
                case 11: {
                    cpuFreq = ParseUtil.parseHertz(splitLine[1]);
                }
            }
        }
        if (cpuName.contains("Hz")) {
            cpuFreq = -1L;
        } else {
            long cpuCapacity = Lshw.queryCpuCapacity();
            if (cpuCapacity > cpuFreq) {
                cpuFreq = cpuCapacity;
            }
        }
        if (cpuStepping.isEmpty()) {
            cpuStepping = armStepping.toString();
        }
        String processorID = LinuxCentralProcessor.getProcessorID(cpuVendor, cpuStepping, cpuModel, cpuFamily, flags);
        if (cpuVendor.startsWith("0x")) {
            List<String> list2 = ExecutingCommand.runNative("lscpu");
            Iterator<String> iterator = list2.iterator();
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (!line.startsWith("Architecture:")) continue;
                cpuVendor = line.replace("Architecture:", "").trim();
            }
        }
        return new CentralProcessor.ProcessorIdentifier((String)var1_1, (String)var2_2, (String)var3_3, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        void var3_3;
        void var1_1;
        Iterator iterator;
        Map<Integer, Integer> numaNodeMap = LinuxCentralProcessor.mapNumaNodes();
        List<String> procCpu = FileUtil.readFile(ProcPath.CPUINFO);
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        int currentProcessor = 0;
        int currentCore = 0;
        int currentPackage = 0;
        boolean first = true;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String cpu = (String)iterator.next();
            if (cpu.startsWith("processor")) {
                if (!first) {
                    logProcs.add(new CentralProcessor.LogicalProcessor(currentProcessor, currentCore, currentPackage, numaNodeMap.getOrDefault(currentProcessor, 0)));
                } else {
                    first = false;
                }
                currentProcessor = ParseUtil.parseLastInt(cpu, 0);
                continue;
            }
            if (cpu.startsWith("core id") || cpu.startsWith("cpu number")) {
                currentCore = ParseUtil.parseLastInt(cpu, 0);
                continue;
            }
            if (!cpu.startsWith("physical id")) continue;
            currentPackage = ParseUtil.parseLastInt(cpu, 0);
        }
        logProcs.add(new CentralProcessor.LogicalProcessor(currentProcessor, currentCore, currentPackage, var1_1.getOrDefault(currentProcessor, 0)));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Integer, Integer> mapNumaNodes() {
        void var0;
        HashMap<Integer, Integer> numaNodeMap = new HashMap<Integer, Integer>();
        Object object = ExecutingCommand.runNative("lscpu -p=cpu,node");
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            String[] split;
            String line = (String)object.next();
            if (line.startsWith("#") || (split = line.split(",")).length != 2) continue;
            numaNodeMap.put(ParseUtil.parseIntOrDefault(split[0], 0), ParseUtil.parseIntOrDefault((String)var2_2[1], 0));
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] querySystemCpuLoadTicks() {
        void var1_1;
        long[] ticks = CpuStat.getSystemCpuLoadTicks();
        if (LongStream.of(ticks).sum() == 0L) {
            ticks = CpuStat.getSystemCpuLoadTicks();
        }
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            ticks[i] = ticks[i] * 1000L / hz;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] queryCurrentFreq() {
        void var2_3;
        void var3_4;
        int i;
        String cpuFreqPath = GlobalConfig.get(CPUFREQ_PATH, "");
        long[] freqs = new long[this.getLogicalProcessorCount()];
        long max = 0L;
        for (i = 0; i < freqs.length; ++i) {
            freqs[i] = FileUtil.getLongFromFile(cpuFreqPath + "/cpu" + i + "/cpufreq/scaling_cur_freq");
            if (freqs[i] == 0L) {
                freqs[i] = FileUtil.getLongFromFile(cpuFreqPath + "/cpu" + i + "/cpufreq/cpuinfo_cur_freq");
            }
            if (max >= freqs[i]) continue;
            max = freqs[i];
        }
        if (var3_4 > 0L) {
            i = 0;
            while (i < freqs.length) {
                int n = i++;
                freqs[n] = freqs[n] * 1000L;
            }
            return freqs;
        }
        Arrays.fill(freqs, -1L);
        List<String> cpuInfo = FileUtil.readFile(ProcPath.CPUINFO);
        int proc = 0;
        for (String s : cpuInfo) {
            if (!s.toLowerCase().contains("cpu mhz")) continue;
            freqs[proc] = Math.round(ParseUtil.parseLastDouble(s, 0.0) * 1000000.0);
            if (++proc < freqs.length) continue;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryMaxFreq() {
        File file;
        File[] policies;
        String cpuFreqPath = GlobalConfig.get(CPUFREQ_PATH, "");
        long max = Arrays.stream(this.getCurrentFreq()).max().orElse(-1L);
        if (max > 0L) {
            max /= 1000L;
        }
        if ((policies = (file = new File(cpuFreqPath + "/cpufreq")).listFiles()) != null) {
            for (int i = 0; i < policies.length; ++i) {
                File f = policies[i];
                if (!f.getName().startsWith("policy")) continue;
                long freq = FileUtil.getLongFromFile(cpuFreqPath + "/cpufreq/" + f.getName() + "/scaling_max_freq");
                if (freq == 0L) {
                    freq = FileUtil.getLongFromFile(cpuFreqPath + "/cpufreq/" + f.getName() + "/cpuinfo_max_freq");
                }
                if (max >= freq) continue;
                max = freq;
            }
        }
        if (max > 0L) {
            void var2_2;
            long lshwMax = Lshw.queryCpuCapacity();
            if (lshwMax > (max *= 1000L)) {
                return lshwMax;
            }
            return (long)var2_2;
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double[] getSystemLoadAverage(int nelem) {
        void var2_2;
        if (nelem <= 0 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = LinuxLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < nelem; ++i) {
                average[i] = -1.0;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[][] queryProcessorCpuLoadTicks() {
        void var1_1;
        long[][] ticks = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        if (LongStream.of(ticks[0]).sum() == 0L) {
            ticks = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        }
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            for (int j = 0; j < ticks[i].length; ++j) {
                ticks[i][j] = ticks[i][j] * 1000L / hz;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getProcessorID(String vendor, String stepping, String model, String family, String[] flags) {
        void var3_3;
        void var2_2;
        String string;
        void var1_1;
        boolean procInfo = false;
        String marker = "Processor Information";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t 4")) {
            if (!procInfo && checkLine.contains(marker)) {
                marker = "ID:";
                procInfo = true;
                continue;
            }
            if (!procInfo || !checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        marker = "eax=";
        for (String checkLine : ExecutingCommand.runNative("cpuid -1r")) {
            if (!checkLine.contains(marker) || !checkLine.trim().startsWith("0x00000001")) continue;
            String eax = "";
            String edx = "";
            for (String register : ParseUtil.whitespaces.split(checkLine)) {
                if (register.startsWith("eax=")) {
                    eax = ParseUtil.removeMatchingString(register, "eax=0x");
                    continue;
                }
                if (!register.startsWith("edx=")) continue;
                edx = ParseUtil.removeMatchingString(register, "edx=0x");
            }
            return (String)var1_1 + string;
        }
        if (string.startsWith("0x")) {
            return LinuxCentralProcessor.createMIDR(string, (String)var1_1, (String)model, family) + "00000000";
        }
        return LinuxCentralProcessor.createProcessorID((String)var1_1, (String)var2_2, (String)var3_3, flags);
    }

    /*
     * WARNING - void declaration
     */
    private static String createMIDR(String vendor, String stepping, String model, String family) {
        String string;
        void var3_3;
        void var2_2;
        int midrBytes = 0;
        if (stepping.startsWith("r") && stepping.contains("p")) {
            void var1_1;
            String[] rev = stepping.substring(1).split("p");
            midrBytes = 0 | ParseUtil.parseLastInt(rev[1], 0);
            midrBytes |= ParseUtil.parseLastInt((String)var1_1[0], 0) << 20;
        }
        midrBytes |= ParseUtil.parseLastInt((String)var2_2, 0) << 4;
        midrBytes |= ParseUtil.parseLastInt((String)var3_3, 0) << 16;
        return String.format("%08X", midrBytes |= ParseUtil.parseLastInt(string, 0) << 24);
    }

    @Override
    public final long queryContextSwitches() {
        return CpuStat.getContextSwitches();
    }

    @Override
    public final long queryInterrupts() {
        return CpuStat.getInterrupts();
    }
}

