/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.driver.linux.Dmidecode;
import oshi.driver.linux.Sysfs;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@Immutable
final class LinuxFirmware
extends AbstractFirmware {
    private static final DateTimeFormatter VCGEN_FORMATTER = DateTimeFormatter.ofPattern("MMM d uuuu HH:mm:ss", Locale.ENGLISH);
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<String> description = Memoizer.memoize(this::queryDescription);
    private final Supplier<String> version = Memoizer.memoize(this::queryVersion);
    private final Supplier<String> releaseDate = Memoizer.memoize(this::queryReleaseDate);
    private final Supplier<String> name = Memoizer.memoize(this::queryName);
    private final Supplier<VcGenCmdStrings> vcGenCmd = Memoizer.memoize(LinuxFirmware::queryVcGenCmd);
    private final Supplier<Pair<String, String>> biosNameRev = Memoizer.memoize(Dmidecode::queryBiosNameRev);

    LinuxFirmware() {
    }

    @Override
    public final String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public final String getDescription() {
        return this.description.get();
    }

    @Override
    public final String getVersion() {
        return this.version.get();
    }

    @Override
    public final String getReleaseDate() {
        return this.releaseDate.get();
    }

    @Override
    public final String getName() {
        return this.name.get();
    }

    /*
     * WARNING - void declaration
     */
    private String queryManufacturer() {
        void var1_1;
        String result = Sysfs.queryBiosVendor();
        if (result == null && (result = this.vcGenCmd.get().manufacturer) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String queryDescription() {
        void var1_1;
        String result = Sysfs.queryBiosDescription();
        if (result == null && (result = this.vcGenCmd.get().description) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String queryVersion() {
        void var1_1;
        String result = Sysfs.queryBiosVersion(this.biosNameRev.get().getB());
        if (result == null && (result = this.vcGenCmd.get().version) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String queryReleaseDate() {
        void var1_1;
        String result = Sysfs.queryBiosReleaseDate();
        if (result == null && (result = this.vcGenCmd.get().releaseDate) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String queryName() {
        void var1_1;
        String result = this.biosNameRev.get().getA();
        if (result == null && (result = this.vcGenCmd.get().name) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static VcGenCmdStrings queryVcGenCmd() {
        List<String> vcgencmd = ExecutingCommand.runNative("vcgencmd version");
        if (vcgencmd.size() >= 3) {
            void var2;
            void var1_2;
            void var0_1;
            String vcReleaseDate;
            try {
                vcReleaseDate = DateTimeFormatter.ISO_LOCAL_DATE.format(VCGEN_FORMATTER.parse(vcgencmd.get(0)));
            }
            catch (DateTimeParseException dateTimeParseException) {
                vcReleaseDate = "unknown";
            }
            String[] copyright = ParseUtil.whitespaces.split(vcgencmd.get(1));
            String vcManufacturer = copyright[copyright.length - 1];
            String vcVersion = vcgencmd.get(2).replace("version ", "");
            return new VcGenCmdStrings((String)var0_1, (String)var1_2, (String)var2, "RPi", "Bootloader");
        }
        return new VcGenCmdStrings(null, null, null, null, null);
    }

    private static final class VcGenCmdStrings {
        private final String releaseDate;
        private final String manufacturer;
        private final String version;
        private final String name;
        private final String description;

        /*
         * WARNING - void declaration
         */
        private VcGenCmdStrings(String releaseDate, String manufacturer, String version, String name, String description) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.releaseDate = var1_1;
            this.manufacturer = var2_2;
            this.version = var3_3;
            this.name = name;
            this.description = description;
        }
    }
}

