/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.GraphicsCard;
import oshi.hardware.common.AbstractGraphicsCard;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@Immutable
final class LinuxGraphicsCard
extends AbstractGraphicsCard {
    /*
     * WARNING - void declaration
     */
    LinuxGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super((String)var1_1, (String)var2_2, (String)var3_3, versionInfo, vram);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<GraphicsCard> getGraphicsCards() {
        void var0;
        List<GraphicsCard> cardList = LinuxGraphicsCard.getGraphicsCardsFromLspci();
        if (cardList.isEmpty()) {
            cardList = LinuxGraphicsCard.getGraphicsCardsFromLshw();
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static List<GraphicsCard> getGraphicsCardsFromLspci() {
        void var0;
        Iterator iterator;
        ArrayList<LinuxGraphicsCard> cardList = new ArrayList<LinuxGraphicsCard>();
        List<String> lspci = ExecutingCommand.runNative("lspci -vnnm");
        String name = "unknown";
        String deviceId = "unknown";
        String vendor = "unknown";
        ArrayList<String> versionInfoList = new ArrayList<String>();
        boolean found = false;
        String lookupDevice = null;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var8_8;
            Pair<String, String> pair;
            String line = (String)iterator.next();
            String[] split = line.trim().split(":", 2);
            String prefix = split[0];
            if (prefix.equals("Class") && line.contains("VGA")) {
                found = true;
            } else if (prefix.equals("Device") && !found && split.length > 1) {
                lookupDevice = split[1].trim();
            }
            if (!found) continue;
            if (split.length < 2) {
                cardList.add(new LinuxGraphicsCard(name, deviceId, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), LinuxGraphicsCard.queryLspciMemorySize(lookupDevice)));
                versionInfoList.clear();
                found = false;
                continue;
            }
            if (prefix.equals("Device")) {
                pair = ParseUtil.parseLspciMachineReadable(split[1].trim());
                if (pair == null) continue;
                name = pair.getA();
                deviceId = "0x" + pair.getB();
                continue;
            }
            if (prefix.equals("Vendor")) {
                pair = ParseUtil.parseLspciMachineReadable(split[1].trim());
                if (pair != null) {
                    vendor = pair.getA() + " (0x" + pair.getB() + ")";
                    continue;
                }
                vendor = split[1].trim();
                continue;
            }
            if (!prefix.equals("Rev:")) continue;
            versionInfoList.add(var8_8.trim());
        }
        if (found) {
            void var3_3;
            void var2_2;
            cardList.add(new LinuxGraphicsCard((String)var2_2, (String)var3_3, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), LinuxGraphicsCard.queryLspciMemorySize(lookupDevice)));
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static long queryLspciMemorySize(String lookupDevice) {
        void var1_1;
        Iterator<String> iterator;
        long vram = 0L;
        iterator = ExecutingCommand.runNative("lspci -v -s " + (String)((Object)iterator));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_2;
            String mem = iterator.next();
            if (!mem.contains(" prefetchable")) continue;
            vram += ParseUtil.parseLspciMemorySize((String)var3_2);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static List<GraphicsCard> getGraphicsCardsFromLshw() {
        void var0;
        void var3_3;
        void var2_2;
        Iterator iterator;
        ArrayList<LinuxGraphicsCard> cardList = new ArrayList<LinuxGraphicsCard>();
        List<String> lshw = ExecutingCommand.runNative("lshw -C display");
        String name = "unknown";
        String deviceId = "unknown";
        String vendor = "unknown";
        ArrayList<String> versionInfoList = new ArrayList<String>();
        long vram = 0L;
        int cardNum = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            String[] split = line.trim().split(":");
            if (split[0].startsWith("*-display")) {
                if (cardNum++ <= 0) continue;
                cardList.add(new LinuxGraphicsCard(name, deviceId, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), vram));
                versionInfoList.clear();
                continue;
            }
            if (split.length != 2) continue;
            String prefix = split[0];
            if (prefix.equals("product")) {
                name = split[1].trim();
                continue;
            }
            if (prefix.equals("vendor")) {
                vendor = split[1].trim();
                continue;
            }
            if (prefix.equals("version")) {
                versionInfoList.add(line.trim());
                continue;
            }
            if (!prefix.startsWith("resources")) continue;
            vram = ParseUtil.parseLshwResourceString(split[1].trim());
        }
        cardList.add(new LinuxGraphicsCard((String)var2_2, (String)var3_3, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), vram));
        return var0;
    }
}

