/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oshi.hardware.LogicalVolumeGroup;
import oshi.hardware.common.AbstractLogicalVolumeGroup;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.Util;

final class LinuxLogicalVolumeGroup
extends AbstractLogicalVolumeGroup {
    private static final String BLOCK = "block";
    private static final String DM_UUID = "DM_UUID";
    private static final String DM_VG_NAME = "DM_VG_NAME";
    private static final String DM_LV_NAME = "DM_LV_NAME";
    private static final String DEV_LOCATION = "/dev/";

    /*
     * WARNING - void declaration
     */
    LinuxLogicalVolumeGroup(String name, Map<String, Set<String>> lvMap, Set<String> pvSet) {
        super((String)var1_1, (Map<String, Set<String>>)var2_2, (Set<String>)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static List<LogicalVolumeGroup> getLogicalVolumeGroups() {
        void var1_4;
        void var0;
        HashMap<String, Map> logicalVolumesMap2 = new HashMap<String, Map>();
        HashMap<String, Set> physicalVolumesMap = new HashMap<String, Set>();
        Iterator<String> iterator = ExecutingCommand.runNative("pvs -o vg_name,pv_name").iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            String[] split = ParseUtil.whitespaces.split(s.trim());
            if (split.length != 2 || !split[1].startsWith(DEV_LOCATION)) continue;
            physicalVolumesMap.computeIfAbsent(split[0], k -> new HashSet()).add(split[1]);
        }
        Udev.UdevContext udev = Udev.INSTANCE.udev_new();
        try {
            Udev.UdevEnumerate enumerate = udev.enumerateNew();
            try {
                enumerate.addMatchSubsystem(BLOCK);
                enumerate.scanDevices();
                for (Udev.UdevListEntry entry = enumerate.getListEntry(); entry != null; entry = entry.getNext()) {
                    Object syspath = entry.getName();
                    Udev.UdevDevice device = udev.deviceNewFromSyspath((String)syspath);
                    if (device == null) continue;
                    try {
                        String uuid;
                        String devnode = device.getDevnode();
                        if (devnode == null || !devnode.startsWith("/dev/dm") || (uuid = device.getPropertyValue(DM_UUID)) == null || !uuid.startsWith("LVM-")) continue;
                        String vgName = device.getPropertyValue(DM_VG_NAME);
                        String lvName = device.getPropertyValue(DM_LV_NAME);
                        if (Util.isBlank(vgName) || Util.isBlank(lvName)) continue;
                        logicalVolumesMap2.computeIfAbsent(vgName, k -> new HashMap());
                        Map lvMapForGroup = (Map)logicalVolumesMap2.get(vgName);
                        physicalVolumesMap.computeIfAbsent(vgName, k -> new HashSet());
                        Set pvSetForGroup = (Set)physicalVolumesMap.get(vgName);
                        syspath = new File((String)syspath + "/slaves");
                        File[] slaves = ((File)syspath).listFiles();
                        if (slaves == null) continue;
                        File[] fileArray = slaves;
                        int n = slaves.length;
                        for (int i = 0; i < n; ++i) {
                            File file = fileArray[i];
                            String pvName = file.getName();
                            lvMapForGroup.computeIfAbsent(lvName, k -> new HashSet()).add(DEV_LOCATION + pvName);
                            pvSetForGroup.add(DEV_LOCATION + pvName);
                        }
                        continue;
                    }
                    finally {
                        device.unref();
                    }
                }
            }
            catch (Throwable logicalVolumesMap2) {
                void var3_6;
                var3_6.unref();
                throw logicalVolumesMap2;
            }
            enumerate.unref();
        }
        catch (Throwable logicalVolumesMap2) {
            iterator.unref();
            throw logicalVolumesMap2;
        }
        udev.unref();
        return var0.entrySet().stream().map(arg_0 -> LinuxLogicalVolumeGroup.lambda$getLogicalVolumeGroups$4((Map)var1_4, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ LinuxLogicalVolumeGroup lambda$getLogicalVolumeGroups$4(Map physicalVolumesMap, Map.Entry e) {
        void var1_1;
        Map map;
        return new LinuxLogicalVolumeGroup((String)e.getKey(), (Map)e.getValue(), (Set)map.get(var1_1.getKey()));
    }
}

