/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractSensors;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

@ThreadSafe
final class LinuxSensors
extends AbstractSensors {
    private static final String TEMP = "temp";
    private static final String FAN = "fan";
    private static final String VOLTAGE = "in";
    private static final String[] SENSORS = new String[]{"temp", "fan", "in"};
    private static final String HWMON = "hwmon";
    private static final String HWMON_PATH = "/sys/class/hwmon/hwmon";
    private static final String THERMAL_ZONE = "thermal_zone";
    private static final String THERMAL_ZONE_PATH = "/sys/class/thermal/thermal_zone";
    private static final boolean IS_PI = LinuxSensors.queryCpuTemperatureFromVcGenCmd() > 0.0;
    private final Map<String, String> sensorsMap = new HashMap<String, String>();

    LinuxSensors() {
        if (!IS_PI) {
            this.populateSensorsMapFromHwmon();
            if (!this.sensorsMap.containsKey(TEMP)) {
                this.populateSensorsMapFromThermalZone();
            }
        }
    }

    private void populateSensorsMapFromHwmon() {
        String[] stringArray = SENSORS;
        int n = SENSORS.length;
        for (int i = 0; i < n; ++i) {
            String sensor;
            String sensorPrefix = sensor = stringArray[i];
            this.getSensorFilesFromPath(HWMON_PATH, sensor, f -> {
                try {
                    void var1_1;
                    String string;
                    return f.getName().startsWith(string) && f.getName().endsWith("_input") && FileUtil.getIntFromFile(var1_1.getCanonicalPath()) > 0;
                }
                catch (IOException iOException) {
                    return false;
                }
            });
        }
    }

    private void populateSensorsMapFromThermalZone() {
        this.getSensorFilesFromPath(THERMAL_ZONE_PATH, TEMP, f -> f.getName().equals(TEMP));
    }

    private void getSensorFilesFromPath(String sensorPath, String sensor, FileFilter sensorFileFilter) {
        int i = 0;
        while (Paths.get(sensorPath + i, new String[0]).toFile().isDirectory()) {
            String path = sensorPath + i;
            File file = new File(path);
            File[] matchingFiles = file.listFiles(sensorFileFilter);
            if (matchingFiles != null && matchingFiles.length > 0) {
                this.sensorsMap.put(sensor, String.format("%s/%s", path, sensor));
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double queryCpuTemperature() {
        if (IS_PI) {
            return LinuxSensors.queryCpuTemperatureFromVcGenCmd();
        }
        String tempStr = this.sensorsMap.get(TEMP);
        if (tempStr != null) {
            void var1_1;
            long millidegrees2;
            if (tempStr.contains(HWMON)) {
                long millidegrees2 = FileUtil.getLongFromFile(String.format("%s1_input", tempStr));
                if (millidegrees2 > 0L) {
                    return (double)millidegrees2 / 1000.0;
                }
                long sum = 0L;
                int count = 0;
                for (int i = 2; i <= 6; ++i) {
                    millidegrees2 = FileUtil.getLongFromFile(String.format("%s%d_input", tempStr, i));
                    if (millidegrees2 <= 0L) continue;
                    sum += millidegrees2;
                    ++count;
                }
                if (count > 0) {
                    return (double)sum / ((double)count * 1000.0);
                }
            } else if (tempStr.contains(THERMAL_ZONE) && (millidegrees2 = FileUtil.getLongFromFile((String)var1_1)) > 0L) {
                void var2_3;
                return (double)var2_3 / 1000.0;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private static double queryCpuTemperatureFromVcGenCmd() {
        String tempStr = ExecutingCommand.getFirstAnswer("vcgencmd measure_temp");
        if (tempStr.startsWith("temp=")) {
            void var0;
            return ParseUtil.parseDoubleOrDefault(var0.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }

    @Override
    public final int[] queryFanSpeeds() {
        String fanStr;
        if (!IS_PI && (fanStr = this.sensorsMap.get(FAN)) != null) {
            String fanPath;
            ArrayList<Integer> speeds = new ArrayList<Integer>();
            int fan = 1;
            while (new File(fanPath = String.format("%s%d_input", fanStr, fan)).exists()) {
                speeds.add(FileUtil.getIntFromFile(fanPath));
                ++fan;
            }
            int[] fanSpeeds = new int[speeds.size()];
            for (int i = 0; i < speeds.size(); ++i) {
                fanSpeeds[i] = (Integer)speeds.get(i);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double queryCpuVoltage() {
        if (IS_PI) {
            return LinuxSensors.queryCpuVoltageFromVcGenCmd();
        }
        String voltageStr = this.sensorsMap.get(VOLTAGE);
        if (voltageStr != null) {
            void var1_1;
            return (double)FileUtil.getIntFromFile(String.format("%s1_input", var1_1)) / 1000.0;
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private static double queryCpuVoltageFromVcGenCmd() {
        String voltageStr = ExecutingCommand.getFirstAnswer("vcgencmd measure_volts core");
        if (voltageStr.startsWith("volt=")) {
            void var0;
            return ParseUtil.parseDoubleOrDefault(var0.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }
}

