/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.platform.linux.Udev;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;

@Immutable
public class LinuxUsbDevice
extends AbstractUsbDevice {
    /*
     * WARNING - void declaration
     */
    public LinuxUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, String uniqueDeviceId, List<UsbDevice> connectedDevices) {
        super((String)var1_1, (String)var2_2, (String)var3_3, productId, serialNumber, uniqueDeviceId, connectedDevices);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<UsbDevice> getUsbDevices(boolean tree) {
        void var0_1;
        Iterator iterator;
        List<UsbDevice> devices = LinuxUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            UsbDevice device = (UsbDevice)iterator.next();
            deviceList.add(new LinuxUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), device.getUniqueDeviceId(), Collections.emptyList()));
            LinuxUsbDevice.addDevicesToList(deviceList, var2_3.getConnectedDevices());
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static List<UsbDevice> getUsbDevices() {
        void var2_2;
        void var3_3;
        void var0;
        void var1_1;
        Udev.UdevListEntry dev_list_entry;
        Udev.UdevContext udev = Udev.INSTANCE.udev_new();
        Udev.UdevEnumerate enumerate = Udev.INSTANCE.udev_enumerate_new(udev);
        Udev.INSTANCE.udev_enumerate_add_match_subsystem(enumerate, "usb");
        Udev.INSTANCE.udev_enumerate_scan_devices(enumerate);
        Udev.UdevListEntry devices = Udev.INSTANCE.udev_enumerate_get_list_entry(enumerate);
        ArrayList<String> usbControllers = new ArrayList<String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> vendorMap = new HashMap<String, String>();
        HashMap<String, String> vendorIdMap = new HashMap<String, String>();
        HashMap<String, String> productIdMap = new HashMap<String, String>();
        HashMap<String, String> serialMap = new HashMap<String, String>();
        HashMap<String, List<String>> hubMap = new HashMap<String, List<String>>();
        while (dev_list_entry != null) {
            String path = Udev.INSTANCE.udev_list_entry_get_name(dev_list_entry);
            Udev.UdevDevice dev = Udev.INSTANCE.udev_device_new_from_syspath(udev, path);
            if ("usb_device".equals(Udev.INSTANCE.udev_device_get_devtype(dev))) {
                Udev.UdevDevice parent;
                String value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "product");
                if (value != null) {
                    nameMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "manufacturer")) != null) {
                    vendorMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "idVendor")) != null) {
                    vendorIdMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "idProduct")) != null) {
                    productIdMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "serial")) != null) {
                    serialMap.put(path, value);
                }
                if ((parent = Udev.INSTANCE.udev_device_get_parent_with_subsystem_devtype(dev, "usb", "usb_device")) == null) {
                    usbControllers.add(path);
                } else {
                    String parentPath = Udev.INSTANCE.udev_device_get_syspath(parent);
                    hubMap.computeIfAbsent(parentPath, x -> new ArrayList()).add(path);
                }
                Udev.INSTANCE.udev_device_unref(dev);
            }
            dev_list_entry = Udev.INSTANCE.udev_list_entry_get_next(dev_list_entry);
        }
        Udev.INSTANCE.udev_enumerate_unref((Udev.UdevEnumerate)var1_1);
        Udev.INSTANCE.udev_unref((Udev.UdevContext)var0);
        ArrayList<LinuxUsbDevice> controllerDevices = new ArrayList<LinuxUsbDevice>();
        for (String controller : var3_3) {
            controllerDevices.add(LinuxUsbDevice.getDeviceAndChildren(controller, "0000", "0000", nameMap, vendorMap, vendorIdMap, productIdMap, serialMap, hubMap));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void addDevicesToList(List<UsbDevice> deviceList, List<UsbDevice> list) {
        for (UsbDevice device : list) {
            void var2_2;
            deviceList.add(device);
            LinuxUsbDevice.addDevicesToList(deviceList, var2_2.getConnectedDevices());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static LinuxUsbDevice getDeviceAndChildren(String devPath, String vid, String pid, Map<String, String> nameMap, Map<String, String> vendorMap, Map<String, String> vendorIdMap, Map<String, String> productIdMap, Map<String, String> serialMap, Map<String, List<String>> hubMap) {
        String string;
        void var2_2;
        void var1_1;
        void var3_3;
        String vendorId = vendorIdMap.getOrDefault(devPath, vid);
        String productId = productIdMap.getOrDefault(devPath, pid);
        List childPaths = hubMap.getOrDefault(devPath, new ArrayList());
        ArrayList<UsbDevice> usbDevices = new ArrayList<UsbDevice>();
        for (String path : childPaths) {
            usbDevices.add(LinuxUsbDevice.getDeviceAndChildren(path, vendorId, productId, nameMap, vendorMap, vendorIdMap, productIdMap, serialMap, hubMap));
        }
        Collections.sort(usbDevices);
        return new LinuxUsbDevice(var3_3.getOrDefault(devPath, vendorId + ":" + productId), vendorMap.getOrDefault(devPath, ""), (String)var1_1, (String)var2_2, serialMap.getOrDefault(devPath, ""), string, usbDevices);
    }
}

