/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.util.FormatUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.platform.mac.SysctlUtil;
import oshi.util.tuples.Triplet;

@ThreadSafe
final class MacCentralProcessor
extends AbstractCentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MacCentralProcessor.class);
    private final Supplier<String> vendor = Memoizer.memoize(MacCentralProcessor::platformExpert);
    private final Supplier<Triplet<Integer, Integer, Long>> typeFamilyFreq = Memoizer.memoize(MacCentralProcessor::queryArmCpu);
    private static final int ROSETTA_CPUTYPE = 7;
    private static final int ROSETTA_CPUFAMILY = 1463508716;
    private static final int M1_CPUTYPE = 0x100000C;
    private static final int M1_CPUFAMILY = 458787763;

    MacCentralProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final CentralProcessor.ProcessorIdentifier queryProcessorId() {
        void var3_4;
        void var1_1;
        void var2_3;
        String processorID;
        String cpuFamily;
        String cpuModel;
        String cpuStepping;
        String cpuVendor;
        String cpuName = SysctlUtil.sysctl("machdep.cpu.brand_string", "");
        long cpuFreq = 0L;
        if (cpuName.startsWith("Apple")) {
            cpuVendor = this.vendor.get();
            cpuStepping = "0";
            cpuModel = "0";
            int type = SysctlUtil.sysctl("hw.cputype", 0);
            int family = SysctlUtil.sysctl("hw.cpufamily", 0);
            if (family == 1463508716) {
                type = this.typeFamilyFreq.get().getA();
                family = this.typeFamilyFreq.get().getB();
            }
            cpuFreq = this.typeFamilyFreq.get().getC();
            cpuFamily = String.format("0x%08x", family);
            processorID = String.format("%08x%08x", type, family);
        } else {
            cpuVendor = SysctlUtil.sysctl("machdep.cpu.vendor", "");
            int i = SysctlUtil.sysctl("machdep.cpu.stepping", -1);
            cpuStepping = i < 0 ? "" : Integer.toString(i);
            i = SysctlUtil.sysctl("machdep.cpu.model", -1);
            cpuModel = i < 0 ? "" : Integer.toString(i);
            i = SysctlUtil.sysctl("machdep.cpu.family", -1);
            cpuFamily = i < 0 ? "" : Integer.toString(i);
            long family = 0L | (long)SysctlUtil.sysctl("machdep.cpu.signature", 0);
            long processorIdBits = family | SysctlUtil.sysctl("machdep.cpu.feature_bits", 0L) << 32;
            processorID = String.format("%016x", processorIdBits);
        }
        if (cpuFreq == 0L) {
            cpuFreq = SysctlUtil.sysctl("hw.cpufrequency", 0L);
        }
        boolean cpu64bit = SysctlUtil.sysctl("hw.cpu64bit_capable", 0) != 0;
        return new CentralProcessor.ProcessorIdentifier((String)var2_3, (String)var1_1, cpuFamily, cpuModel, (String)var3_4, processorID, cpu64bit, cpuFreq);
    }

    @Override
    protected final List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        int logicalProcessorCount = SysctlUtil.sysctl("hw.logicalcpu", 1);
        int physicalProcessorCount = SysctlUtil.sysctl("hw.physicalcpu", 1);
        int physicalPackageCount = SysctlUtil.sysctl("hw.packages", 1);
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>(logicalProcessorCount);
        for (int i = 0; i < logicalProcessorCount; ++i) {
            int n = i;
            logProcs.add(new CentralProcessor.LogicalProcessor(n, n * physicalProcessorCount / logicalProcessorCount, i * physicalPackageCount / logicalProcessorCount));
        }
        return logProcs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] querySystemCpuLoadTicks() {
        void var1_1;
        void var3_3;
        void var2_2;
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        SystemB.HostCpuLoadInfo cpuLoadInfo = new SystemB.HostCpuLoadInfo();
        if (0 != SystemB.INSTANCE.host_statistics((int)var2_2, 3, (Structure)cpuLoadInfo, new IntByReference(cpuLoadInfo.size()))) {
            LOG.error("Failed to get System CPU ticks. Error code: {} ", (Object)Native.getLastError());
            return ticks;
        }
        ticks[CentralProcessor.TickType.USER.getIndex()] = cpuLoadInfo.cpu_ticks[0];
        ticks[CentralProcessor.TickType.NICE.getIndex()] = cpuLoadInfo.cpu_ticks[3];
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpuLoadInfo.cpu_ticks[1];
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = var3_3.cpu_ticks[2];
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] queryCurrentFreq() {
        void var1_1;
        long[] lArray = new long[1];
        long[] freq = lArray;
        lArray[0] = SysctlUtil.sysctl("hw.cpufrequency", this.getProcessorIdentifier().getVendorFreq());
        return var1_1;
    }

    @Override
    public final long queryMaxFreq() {
        return SysctlUtil.sysctl("hw.cpufrequency_max", this.getProcessorIdentifier().getVendorFreq());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double[] getSystemLoadAverage(int nelem) {
        void var2_2;
        void var1_1;
        if (nelem <= 0 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int n = SystemB.INSTANCE.getloadavg(average, nelem);
        if (n < var1_1) {
            Arrays.fill(average, -1.0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[][] queryProcessorCpuLoadTicks() {
        void var1_1;
        IntByReference procInfoCount;
        PointerByReference procCpuLoadInfo;
        IntByReference procCount;
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_processor_info(machPort, 2, procCount = new IntByReference(), procCpuLoadInfo = new PointerByReference(), procInfoCount = new IntByReference())) {
            LOG.error("Failed to update CPU Load. Error code: {}", (Object)Native.getLastError());
            return ticks;
        }
        int[] cpuTicks = procCpuLoadInfo.getValue().getIntArray(0L, procInfoCount.getValue());
        for (int cpu = 0; cpu < procCount.getValue(); ++cpu) {
            int offset = cpu << 2;
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset]);
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset + 3]);
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset + 1]);
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset + 2]);
        }
        return var1_1;
    }

    @Override
    public final long queryContextSwitches() {
        return 0L;
    }

    @Override
    public final long queryInterrupts() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    private static String platformExpert() {
        void var0;
        String manufacturer = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            void var1_1;
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                void var2_2;
                manufacturer = Native.toString((byte[])var2_2, (Charset)StandardCharsets.UTF_8);
            }
            var1_1.release();
        }
        if (Util.isBlank(manufacturer)) {
            return "Apple Inc.";
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<Integer, Integer, Long> queryArmCpu() {
        void var2_2;
        void var1_1;
        void var0;
        int type = 7;
        int family = 1463508716;
        long freq = 0L;
        IOKit.IOIterator iter = IOKitUtil.getMatchingServices((String)"IOPlatformDevice");
        if (iter != null) {
            HashSet<String> compatibleStrSet = new HashSet<String>();
            IOKit.IORegistryEntry cpu = iter.next();
            while (cpu != null) {
                if (cpu.getName().startsWith("cpu")) {
                    long cpuFreq;
                    byte[] data = cpu.getByteArrayProperty("clock-frequency");
                    if (data != null && (cpuFreq = ParseUtil.byteArrayToLong(data, data.length, false) * 1000L) > freq) {
                        freq = cpuFreq;
                    }
                    if ((data = cpu.getByteArrayProperty("compatible")) != null) {
                        for (String s : new String(data, StandardCharsets.UTF_8).split("\u0000")) {
                            if (s.isEmpty()) continue;
                            compatibleStrSet.add(s);
                        }
                    }
                }
                cpu.release();
                cpu = iter.next();
            }
            iter.release();
            List<String> m1compatible = Arrays.asList("ARM,v8", "apple,firestorm", "apple,icestorm");
            compatibleStrSet.retainAll(m1compatible);
            if (compatibleStrSet.size() == m1compatible.size()) {
                type = 0x100000C;
                family = 458787763;
            }
        }
        return new Triplet<Integer, Integer, Long>((int)var0, (int)var1_1, (long)var2_2);
    }
}

