/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HWDiskStore;
import oshi.hardware.LogicalVolumeGroup;
import oshi.hardware.NetworkIF;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.SoundCard;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractHardwareAbstractionLayer;
import oshi.hardware.platform.mac.MacCentralProcessor;
import oshi.hardware.platform.mac.MacComputerSystem;
import oshi.hardware.platform.mac.MacDisplay;
import oshi.hardware.platform.mac.MacGlobalMemory;
import oshi.hardware.platform.mac.MacGraphicsCard;
import oshi.hardware.platform.mac.MacHWDiskStore;
import oshi.hardware.platform.mac.MacLogicalVolumeGroup;
import oshi.hardware.platform.mac.MacNetworkIF;
import oshi.hardware.platform.mac.MacPowerSource;
import oshi.hardware.platform.mac.MacSensors;
import oshi.hardware.platform.mac.MacSoundCard;
import oshi.hardware.platform.mac.MacUsbDevice;

@ThreadSafe
public final class MacHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public final ComputerSystem createComputerSystem() {
        return new MacComputerSystem();
    }

    @Override
    public final GlobalMemory createMemory() {
        return new MacGlobalMemory();
    }

    @Override
    public final CentralProcessor createProcessor() {
        return new MacCentralProcessor();
    }

    @Override
    public final Sensors createSensors() {
        return new MacSensors();
    }

    @Override
    public final List<PowerSource> getPowerSources() {
        return MacPowerSource.getPowerSources();
    }

    @Override
    public final List<HWDiskStore> getDiskStores() {
        return MacHWDiskStore.getDisks();
    }

    @Override
    public final List<LogicalVolumeGroup> getLogicalVolumeGroups() {
        return MacLogicalVolumeGroup.getLogicalVolumeGroups();
    }

    @Override
    public final List<Display> getDisplays() {
        return MacDisplay.getDisplays();
    }

    @Override
    public final List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return MacNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public final List<UsbDevice> getUsbDevices(boolean tree) {
        return MacUsbDevice.getUsbDevices(tree);
    }

    @Override
    public final List<SoundCard> getSoundCards() {
        return MacSoundCard.getSoundCards();
    }

    @Override
    public final List<GraphicsCard> getGraphicsCards() {
        return MacGraphicsCard.getGraphicsCards();
    }
}

