/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oshi.hardware.LogicalVolumeGroup;
import oshi.hardware.common.AbstractLogicalVolumeGroup;
import oshi.util.ExecutingCommand;

final class MacLogicalVolumeGroup
extends AbstractLogicalVolumeGroup {
    private static final String DISKUTIL_CS_LIST = "diskutil cs list";
    private static final String LOGICAL_VOLUME_GROUP = "Logical Volume Group";
    private static final String PHYSICAL_VOLUME = "Physical Volume";
    private static final String LOGICAL_VOLUME = "Logical Volume";

    /*
     * WARNING - void declaration
     */
    MacLogicalVolumeGroup(String name, Map<String, Set<String>> lvMap, Set<String> pvSet) {
        super((String)var1_1, (Map<String, Set<String>>)var2_2, (Set<String>)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static List<LogicalVolumeGroup> getLogicalVolumeGroups() {
        void var1_1;
        void var0;
        HashMap<String, Map> logicalVolumesMap = new HashMap<String, Map>();
        HashMap<String, Set> physicalVolumesMap = new HashMap<String, Set>();
        String currentVolumeGroup = null;
        boolean lookForVGName = false;
        boolean lookForPVName = false;
        for (String line : ExecutingCommand.runNative(DISKUTIL_CS_LIST)) {
            int indexOf;
            if (line.contains(LOGICAL_VOLUME_GROUP)) {
                lookForVGName = true;
                continue;
            }
            if (lookForVGName) {
                indexOf = line.indexOf("Name:");
                if (indexOf < 0) continue;
                currentVolumeGroup = line.substring(indexOf + 5).trim();
                lookForVGName = false;
                continue;
            }
            if (line.contains(PHYSICAL_VOLUME)) {
                lookForPVName = true;
                continue;
            }
            if (line.contains(LOGICAL_VOLUME)) {
                lookForPVName = false;
                continue;
            }
            indexOf = line.indexOf("Disk:");
            if (indexOf < 0) continue;
            if (lookForPVName) {
                physicalVolumesMap.computeIfAbsent(currentVolumeGroup, k -> new HashSet()).add(line.substring(indexOf + 5).trim());
                continue;
            }
            logicalVolumesMap.computeIfAbsent(currentVolumeGroup, k -> new HashMap()).put(line.substring(indexOf + 5).trim(), Collections.emptySet());
        }
        return var0.entrySet().stream().map(arg_0 -> MacLogicalVolumeGroup.lambda$getLogicalVolumeGroups$2((Map)var1_1, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ MacLogicalVolumeGroup lambda$getLogicalVolumeGroups$2(Map physicalVolumesMap, Map.Entry e) {
        void var1_1;
        Map map;
        return new MacLogicalVolumeGroup((String)e.getKey(), (Map)e.getValue(), (Set)map.get(var1_1.getKey()));
    }
}

