/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.platform.mac.IOKit;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractSensors;
import oshi.util.platform.mac.SmcUtil;

@ThreadSafe
final class MacSensors
extends AbstractSensors {
    private int numFans = 0;

    MacSensors() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double queryCpuTemperature() {
        void var1_1;
        IOKit.IOConnect conn = SmcUtil.smcOpen();
        double temp = SmcUtil.smcGetFloat(conn, "TC0P");
        SmcUtil.smcClose((IOKit.IOConnect)var1_1);
        if (temp > 0.0) {
            void var2_2;
            return (double)var2_2;
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int[] queryFanSpeeds() {
        void var2_2;
        void var1_1;
        IOKit.IOConnect conn = SmcUtil.smcOpen();
        if (this.numFans == 0) {
            this.numFans = (int)SmcUtil.smcGetLong(conn, "FNum");
        }
        int[] fanSpeeds = new int[this.numFans];
        for (int i = 0; i < this.numFans; ++i) {
            fanSpeeds[i] = (int)SmcUtil.smcGetFloat(conn, String.format("F%dAc", i));
        }
        SmcUtil.smcClose((IOKit.IOConnect)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double queryCpuVoltage() {
        void var2_2;
        void var1_1;
        IOKit.IOConnect conn = SmcUtil.smcOpen();
        double volts = SmcUtil.smcGetFloat(conn, "VC0C") / 1000.0;
        SmcUtil.smcClose((IOKit.IOConnect)var1_1);
        return (double)var2_2;
    }
}

