/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.SoundCard;
import oshi.hardware.common.AbstractSoundCard;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

@Immutable
final class MacSoundCard
extends AbstractSoundCard {
    private static final String APPLE = "Apple Inc.";

    /*
     * WARNING - void declaration
     */
    MacSoundCard(String kernelVersion, String name, String codec) {
        super((String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<SoundCard> getSoundCards() {
        void var0;
        void var3_3;
        void var1_1;
        void var2_2;
        ArrayList<MacSoundCard> soundCards = new ArrayList<MacSoundCard>();
        String manufacturer = APPLE;
        String kernelVersion = "AppleHDAController";
        String codec = "AppleHDACodec";
        boolean version = false;
        String versionMarker = "<key>com.apple.driver.AppleHDAController</key>";
        for (String checkLine : FileUtil.readFile("/System/Library/Extensions/AppleHDA.kext/Contents/Info.plist")) {
            if (checkLine.contains(versionMarker)) {
                version = true;
                continue;
            }
            if (!version) continue;
            kernelVersion = "AppleHDAController " + ParseUtil.getTextBetweenStrings(checkLine, "<string>", "</string>");
            version = false;
        }
        soundCards.add(new MacSoundCard((String)var2_2, (String)var1_1, (String)var3_3));
        return var0;
    }
}

