/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.aix;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.aix.Ls;
import oshi.driver.unix.aix.Lscfg;
import oshi.driver.unix.aix.Lspv;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.common.AbstractHWDiskStore;
import oshi.util.tuples.Pair;

@ThreadSafe
public final class AixHWDiskStore
extends AbstractHWDiskStore {
    private final Supplier<Perfstat.perfstat_disk_t[]> diskStats;
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private long timeStamp = 0L;
    private List<HWPartition> partitionList;

    /*
     * WARNING - void declaration
     */
    private AixHWDiskStore(String name, String model, String serial, long size, Supplier<Perfstat.perfstat_disk_t[]> diskStats) {
        super((String)var1_1, (String)var2_2, (String)var3_3, size);
        void var3_3;
        void var2_2;
        void var1_1;
        this.diskStats = diskStats;
    }

    @Override
    public final long getReads() {
        return this.reads;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getWrites() {
        return this.writes;
    }

    @Override
    public final long getWriteBytes() {
        return this.writeBytes;
    }

    @Override
    public final long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    @Override
    public final long getTransferTime() {
        return this.transferTime;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public final List<HWPartition> getPartitions() {
        return this.partitionList;
    }

    @Override
    public final boolean updateAttributes() {
        for (Perfstat.perfstat_disk_t stat : this.diskStats.get()) {
            String string = Native.toString((byte[])stat.name);
            if (!string.equals(this.getName())) continue;
            long blks = stat.rblks + stat.wblks;
            this.reads = stat.xfers;
            if (blks > 0L) {
                this.writes = stat.xfers * stat.wblks / blks;
                this.reads -= this.writes;
            }
            this.readBytes = stat.rblks * stat.bsize;
            this.writeBytes = stat.wblks * stat.bsize;
            this.currentQueueLength = stat.qdepth;
            this.transferTime = stat.time;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static List<HWDiskStore> getDisks(Supplier<Perfstat.perfstat_disk_t[]> diskStats) {
        void var2_2;
        Map<String, Pair<Integer, Integer>> majMinMap = Ls.queryDeviceMajorMinor();
        ArrayList<AixHWDiskStore> storeList = new ArrayList<AixHWDiskStore>();
        for (Perfstat.perfstat_disk_t disk : diskStats.get()) {
            String storeName = Native.toString((byte[])disk.name);
            Pair<String, String> ms = Lscfg.queryModelSerial(storeName);
            String model = ms.getA() == null ? Native.toString((byte[])disk.description) : ms.getA();
            String serial = ms.getB() == null ? "unknown" : ms.getB();
            storeList.add(AixHWDiskStore.createStore(storeName, model, serial, disk.size << 20, diskStats, majMinMap));
        }
        return var2_2.stream().sorted(Comparator.comparingInt(s -> {
            AixHWDiskStore aixHWDiskStore;
            if (s.getPartitions().isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return aixHWDiskStore.getPartitions().get(0).getMajor();
        })).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private static AixHWDiskStore createStore(String diskName, String model, String serial, long size, Supplier<Perfstat.perfstat_disk_t[]> diskStats, Map<String, Pair<Integer, Integer>> majMinMap) {
        void var1_1;
        String string;
        void var3_3;
        void var2_2;
        AixHWDiskStore store = new AixHWDiskStore(diskName, model.isEmpty() ? "unknown" : model, (String)var2_2, (long)var3_3, diskStats);
        new AixHWDiskStore(diskName, model.isEmpty() ? "unknown" : model, (String)var2_2, (long)var3_3, diskStats).partitionList = Collections.unmodifiableList(Lspv.queryLogicalVolumes(string, majMinMap).stream().sorted(Comparator.comparing(HWPartition::getMinor).thenComparing(HWPartition::getName)).collect(Collectors.toList()));
        store.updateAttributes();
        return var1_1;
    }
}

