/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.aix;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.aix.perfstat.PerfstatNetInterface;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworkIF;
import oshi.util.Memoizer;

@ThreadSafe
public final class AixNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(AixNetworkIF.class);
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;
    private Supplier<Perfstat.perfstat_netinterface_t[]> netstats;

    /*
     * WARNING - void declaration
     */
    public AixNetworkIF(NetworkInterface netint, Supplier<Perfstat.perfstat_netinterface_t[]> netstats) throws InstantiationException {
        super((NetworkInterface)var1_1);
        void var2_2;
        void var1_1;
        this.netstats = var2_2;
        this.updateAttributes();
    }

    /*
     * WARNING - void declaration
     */
    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        void var2_3;
        boolean bl;
        Supplier<Perfstat.perfstat_netinterface_t[]> netstats = Memoizer.memoize(PerfstatNetInterface::queryNetInterfaces, Memoizer.defaultExpiration());
        ArrayList<AixNetworkIF> ifList = new ArrayList<AixNetworkIF>();
        for (NetworkInterface ni : AixNetworkIF.getNetworkInterfaces(bl)) {
            try {
                ifList.add(new AixNetworkIF(ni, netstats));
            }
            catch (InstantiationException e) {
                void var3_5;
                LOG.debug("Network Interface Instantiation failed: {}", (Object)var3_5.getMessage());
            }
        }
        return var2_3;
    }

    @Override
    public final long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public final long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public final long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public final long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public final long getInErrors() {
        return this.inErrors;
    }

    @Override
    public final long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public final long getInDrops() {
        return this.inDrops;
    }

    @Override
    public final long getCollisions() {
        return this.collisions;
    }

    @Override
    public final long getSpeed() {
        return this.speed;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean updateAttributes() {
        void var1_1;
        Perfstat.perfstat_netinterface_t[] stats = this.netstats.get();
        long now = System.currentTimeMillis();
        for (void stat : var1_1) {
            String string = Native.toString((byte[])stat.name);
            if (!string.equals(this.getName())) continue;
            this.bytesSent = stat.obytes;
            this.bytesRecv = stat.ibytes;
            this.packetsSent = stat.opackets;
            this.packetsRecv = stat.ipackets;
            this.outErrors = stat.oerrors;
            this.inErrors = stat.ierrors;
            this.collisions = stat.collisions;
            this.inDrops = stat.if_iqdrops;
            this.speed = stat.bitrate;
            this.timeStamp = now;
            return true;
        }
        return false;
    }
}

