/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.unix.freebsd.FreeBsdLibc;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

@ThreadSafe
final class FreeBsdCentralProcessor
extends AbstractCentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdCentralProcessor.class);
    private static final Pattern CPUMASK = Pattern.compile(".*<cpu\\s.*mask=\"(?:0x)?(\\p{XDigit}+)\".*>.*</cpu>.*");

    FreeBsdCentralProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final CentralProcessor.ProcessorIdentifier queryProcessorId() {
        void var2_3;
        void var1_1;
        void var3_4;
        Pattern identifierPattern = Pattern.compile("Origin=\"([^\"]*)\".*Id=(\\S+).*Family=(\\S+).*Model=(\\S+).*Stepping=(\\S+).*");
        Pattern featuresPattern = Pattern.compile("Features=(\\S+)<.*");
        String cpuVendor = "";
        String cpuName = BsdSysctlUtil.sysctl("hw.model", "");
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        long cpuFreq = BsdSysctlUtil.sysctl("hw.clockrate", 0L) * 1000000L;
        long processorIdBits = 0L;
        Object object = FileUtil.readFile("/var/run/dmesg.boot");
        object = object.iterator();
        while (object.hasNext()) {
            Matcher m;
            String string = (String)object.next();
            String line = string.trim();
            if (line.startsWith("CPU:") && cpuName.isEmpty()) {
                cpuName = line.replace("CPU:", "").trim();
                continue;
            }
            if (line.startsWith("Origin=")) {
                m = identifierPattern.matcher(line);
                if (!m.matches()) continue;
                cpuVendor = m.group(1);
                processorIdBits |= Long.decode(m.group(2)).longValue();
                cpuFamily = Integer.decode(m.group(3)).toString();
                cpuModel = Integer.decode(m.group(4)).toString();
                cpuStepping = Integer.decode(m.group(5)).toString();
                continue;
            }
            if (!((String)((Object)m)).startsWith("Features=")) continue;
            if (!(m = featuresPattern.matcher((CharSequence)((Object)m))).matches()) break;
            processorIdBits |= Long.decode(m.group(1)) << 32;
            break;
        }
        boolean cpu64bit = ExecutingCommand.getFirstAnswer("uname -m").trim().contains("64");
        String processorID = FreeBsdCentralProcessor.getProcessorIDfromDmiDecode(processorIdBits);
        return new CentralProcessor.ProcessorIdentifier((String)var3_4, cpuName, cpuFamily, cpuModel, cpuStepping, (String)var1_1, (boolean)var2_3, cpuFreq);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        void var1_1;
        List<CentralProcessor.LogicalProcessor> logProcs = FreeBsdCentralProcessor.parseTopology();
        if (logProcs.isEmpty()) {
            logProcs.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static List<CentralProcessor.LogicalProcessor> parseTopology() {
        void var3_2;
        void var1_1;
        void var0;
        String[] topology = BsdSysctlUtil.sysctl("kern.sched.topology_spec", "").split("\\n|\\r");
        long group1 = 1L;
        ArrayList<Long> group2 = new ArrayList<Long>();
        ArrayList<Long> group3 = new ArrayList<Long>();
        int groupLevel = 0;
        block5: for (void topo : var0) {
            Matcher m;
            if (topo.contains("<group level=")) {
                ++groupLevel;
                continue;
            }
            if (topo.contains("</group>")) {
                --groupLevel;
                continue;
            }
            if (!topo.contains("<cpu") || !(m = CPUMASK.matcher((CharSequence)topo)).matches()) continue;
            switch (groupLevel) {
                case 1: {
                    group1 = Long.parseLong(m.group(1), 16);
                    continue block5;
                }
                case 2: {
                    group2.add(Long.parseLong(m.group(1), 16));
                    continue block5;
                }
                case 3: {
                    group3.add(Long.parseLong(m.group(1), 16));
                }
            }
        }
        return FreeBsdCentralProcessor.matchBitmasks((long)var1_1, (List<Long>)var3_2, group3);
    }

    private static List<CentralProcessor.LogicalProcessor> matchBitmasks(long group1, List<Long> group2, List<Long> group3) {
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        int lowBit = Long.numberOfTrailingZeros(group1);
        int hiBit = 63 - Long.numberOfLeadingZeros(group1);
        for (int i = lowBit; i <= hiBit; ++i) {
            if ((group1 & 1L << i) <= 0L) continue;
            CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(i, FreeBsdCentralProcessor.getMatchingBitmask(group3, i), FreeBsdCentralProcessor.getMatchingBitmask(group2, i), 0);
            logProcs.add(logProc);
        }
        return logProcs;
    }

    private static int getMatchingBitmask(List<Long> bitmasks, int lp) {
        for (int j = 0; j < bitmasks.size(); ++j) {
            if ((bitmasks.get(j) & 1L << lp) == 0L) continue;
            return j;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] querySystemCpuLoadTicks() {
        void var1_1;
        void var2_2;
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        FreeBsdLibc.CpTime cpTime = new FreeBsdLibc.CpTime();
        BsdSysctlUtil.sysctl("kern.cp_time", cpTime);
        ticks[CentralProcessor.TickType.USER.getIndex()] = cpTime.cpu_ticks[0];
        ticks[CentralProcessor.TickType.NICE.getIndex()] = cpTime.cpu_ticks[1];
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpTime.cpu_ticks[2];
        ticks[CentralProcessor.TickType.IRQ.getIndex()] = cpTime.cpu_ticks[3];
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = var2_2.cpu_ticks[4];
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] queryCurrentFreq() {
        void var1_1;
        long[] lArray = new long[1];
        long[] freq = lArray;
        lArray[0] = BsdSysctlUtil.sysctl("dev.cpu.0.freq", -1L);
        freq[0] = freq[0] > 0L ? freq[0] * 1000000L : BsdSysctlUtil.sysctl("machdep.tsc_freq", -1L);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryMaxFreq() {
        void var1_1;
        String[] stringArray;
        long max = -1L;
        String freqLevels = BsdSysctlUtil.sysctl("dev.cpu.0.freq_levels", "");
        for (String string : ParseUtil.whitespaces.split((CharSequence)stringArray)) {
            long freq = ParseUtil.parseLongOrDefault(string.split("/")[0], -1L);
            if (max >= freq) continue;
            max = freq;
        }
        max = max > 0L ? (max *= 1000000L) : BsdSysctlUtil.sysctl("machdep.tsc_freq", -1L);
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double[] getSystemLoadAverage(int nelem) {
        void var2_2;
        if (nelem <= 0 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = FreeBsdLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < nelem; ++i) {
                average[i] = -1.0;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[][] queryProcessorCpuLoadTicks() {
        void var1_1;
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        String name = "kern.cp_times";
        long size = new FreeBsdLibc.CpTime().size();
        long arraySize = size * (long)this.getLogicalProcessorCount();
        Memory p = new Memory(arraySize);
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, new IntByReference((int)arraySize), null, 0)) {
            LOG.error("Failed syctl call: {}, Error code: {}", (Object)name, (Object)Native.getLastError());
            return ticks;
        }
        for (int cpu = 0; cpu < this.getLogicalProcessorCount(); ++cpu) {
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = p.getLong(size * (long)cpu + (long)(0 * FreeBsdLibc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = p.getLong(size * (long)cpu + (long)(1 * FreeBsdLibc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = p.getLong(size * (long)cpu + (long)(2 * FreeBsdLibc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = p.getLong(size * (long)cpu + (long)(3 * FreeBsdLibc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = p.getLong(size * (long)cpu + (long)(4 * FreeBsdLibc.UINT64_SIZE));
        }
        return var1_1;
    }

    private static String getProcessorIDfromDmiDecode(long processorID) {
        long l;
        boolean procInfo = false;
        String marker = "Processor Information";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            if (!procInfo && checkLine.contains(marker)) {
                marker = "ID:";
                procInfo = true;
                continue;
            }
            if (!procInfo || !checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        return String.format("%016X", l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryContextSwitches() {
        void var3_3;
        void var2_2;
        void var1_1;
        String name = "vm.stats.sys.v_swtch";
        IntByReference size = new IntByReference(FreeBsdLibc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname((String)var1_1, (Pointer)p, (IntByReference)var2_2, null, 0)) {
            return 0L;
        }
        return ParseUtil.unsignedIntToLong(var3_3.getInt(0L));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryInterrupts() {
        void var3_3;
        void var2_2;
        void var1_1;
        String name = "vm.stats.sys.v_intr";
        IntByReference size = new IntByReference(FreeBsdLibc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname((String)var1_1, (Pointer)p, (IntByReference)var2_2, null, 0)) {
            return 0L;
        }
        return ParseUtil.unsignedIntToLong(var3_3.getInt(0L));
    }
}

