/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.GraphicsCard;
import oshi.hardware.common.AbstractGraphicsCard;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
final class FreeBsdGraphicsCard
extends AbstractGraphicsCard {
    private static final String PCI_CLASS_DISPLAY = "0x03";

    /*
     * WARNING - void declaration
     */
    FreeBsdGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super((String)var1_1, (String)var2_2, (String)var3_3, versionInfo, vram);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<GraphicsCard> getGraphicsCards() {
        void var0;
        Iterator iterator;
        ArrayList<FreeBsdGraphicsCard> cardList = new ArrayList<FreeBsdGraphicsCard>();
        List<String> devices = ExecutingCommand.runNative("pciconf -lv");
        if (devices.isEmpty()) {
            return Collections.emptyList();
        }
        String name22 = "unknown";
        String vendorId = "unknown";
        String productId = "unknown";
        String classCode = "";
        String versionInfo = "unknown";
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String line2 = (String)iterator.next();
            if (line2.contains("class=0x")) {
                if (PCI_CLASS_DISPLAY.equals(classCode)) {
                    cardList.add(new FreeBsdGraphicsCard(name22.isEmpty() ? "unknown" : name22, productId.isEmpty() ? "unknown" : productId, vendorId.isEmpty() ? "unknown" : vendorId, versionInfo.isEmpty() ? "unknown" : versionInfo, 0L));
                }
                String[] stringArray = ParseUtil.whitespaces.split(line2);
                String[] stringArray2 = stringArray;
                stringArray2 = stringArray;
                int name22 = stringArray.length;
                for (int line2 = 0; line2 < name22; ++line2) {
                    String s = stringArray2[line2];
                    String[] keyVal = s.split("=");
                    if (keyVal.length <= 1) continue;
                    if (keyVal[0].equals("class") && keyVal[1].length() >= 4) {
                        classCode = keyVal[1].substring(0, 4);
                        continue;
                    }
                    if (keyVal[0].equals("chip") && keyVal[1].length() >= 10) {
                        productId = keyVal[1].substring(0, 6);
                        vendorId = "0x" + keyVal[1].substring(6, 10);
                        continue;
                    }
                    if (!keyVal[0].contains("rev")) continue;
                    versionInfo = s;
                }
                name22 = "unknown";
                continue;
            }
            String[] split = line2.trim().split("=", 2);
            if (split.length != 2) continue;
            String key = split[0].trim();
            if (key.equals("vendor")) {
                vendorId = ParseUtil.getSingleQuoteStringValue(line2) + (vendorId.equals("unknown") ? "" : " (" + vendorId + ")");
                continue;
            }
            if (!key.equals("device")) continue;
            name22 = ParseUtil.getSingleQuoteStringValue(line2);
        }
        if (PCI_CLASS_DISPLAY.equals(classCode)) {
            void var3_4;
            void var2_2;
            cardList.add(new FreeBsdGraphicsCard((String)(name22.isEmpty() ? "unknown" : var2_2), productId.isEmpty() ? "unknown" : productId, (String)(vendorId.isEmpty() ? "unknown" : var3_4), versionInfo.isEmpty() ? "unknown" : versionInfo, 0L));
        }
        return var0;
    }
}

