/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.unix.openbsd.OpenBsdLibc;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.openbsd.OpenBsdSysctlUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public class OpenBsdCentralProcessor
extends AbstractCentralProcessor {
    private final Supplier<Pair<Long, Long>> vmStats = Memoizer.memoize(OpenBsdCentralProcessor::queryVmStats, Memoizer.defaultExpiration());
    private static final Pattern DMESG_CPU = Pattern.compile("cpu(\\d+): smt (\\d+), core (\\d+), package (\\d+)");

    /*
     * WARNING - void declaration
     */
    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        void var2_3;
        void var3_4;
        void var1_1;
        String cpuVendor = OpenBsdSysctlUtil.sysctl("machdep.cpuvendor", "");
        int[] nArray = new int[2];
        int[] mib = nArray;
        nArray[0] = 6;
        mib[1] = 2;
        String cpuName = OpenBsdSysctlUtil.sysctl(mib, "");
        int cpuid = ParseUtil.hexStringToInt(OpenBsdSysctlUtil.sysctl("machdep.cpuid", ""), 0);
        int cpufeature = ParseUtil.hexStringToInt(OpenBsdSysctlUtil.sysctl("machdep.cpufeature", ""), 0);
        Triplet<Integer, Integer, Integer> cpu = OpenBsdCentralProcessor.cpuidToFamilyModelStepping(cpuid);
        String cpuFamily = cpu.getA().toString();
        String cpuModel = cpu.getB().toString();
        String cpuStepping = cpu.getC().toString();
        long cpuFreq = ParseUtil.parseHertz(cpuName);
        if (cpuFreq < 0L) {
            cpuFreq = this.queryMaxFreq();
        }
        mib[1] = 1;
        String machine = OpenBsdSysctlUtil.sysctl(mib, "");
        boolean cpu64bit = machine != null && machine.contains("64") || ExecutingCommand.getFirstAnswer("uname -m").trim().contains("64");
        String processorID = String.format("%08x%08x", cpufeature, cpuid);
        return new CentralProcessor.ProcessorIdentifier((String)var1_1, (String)var3_4, cpuFamily, cpuModel, cpuStepping, processorID, (boolean)var2_3, cpuFreq);
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<Integer, Integer, Integer> cpuidToFamilyModelStepping(int cpuid) {
        int n;
        void var2_2;
        void var1_1;
        int family = cpuid >> 16 & 0xFF0 | cpuid >> 8 & 0xF;
        int model = cpuid >> 12 & 0xF0 | cpuid >> 4 & 0xF;
        int stepping = cpuid & 0xF;
        return new Triplet<Integer, Integer, Integer>((int)var1_1, (int)var2_2, n);
    }

    @Override
    protected long queryMaxFreq() {
        return this.queryCurrentFreq()[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long[] queryCurrentFreq() {
        void var1_1;
        void var2_2;
        long[] freq = new long[1];
        int[] nArray = new int[2];
        int[] mib = nArray;
        nArray[0] = 6;
        mib[1] = 12;
        freq[0] = OpenBsdSysctlUtil.sysctl((int[])var2_2, 0L) * 1000000L;
        return var1_1;
    }

    @Override
    protected List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        HashMap<Integer, Integer> coreMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> packageMap = new HashMap<Integer, Integer>();
        for (String line : ExecutingCommand.runNative("dmesg")) {
            Matcher m = DMESG_CPU.matcher(line);
            if (!m.matches()) continue;
            int cpu = ParseUtil.parseIntOrDefault(m.group(1), 0);
            coreMap.put(cpu, ParseUtil.parseIntOrDefault(m.group(3), 0));
            packageMap.put(cpu, ParseUtil.parseIntOrDefault(m.group(4), 0));
        }
        int logicalProcessorCount = OpenBsdSysctlUtil.sysctl("hw.ncpuonline", 1);
        if (logicalProcessorCount < coreMap.keySet().size()) {
            logicalProcessorCount = coreMap.keySet().size();
        }
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>(logicalProcessorCount);
        for (int i = 0; i < logicalProcessorCount; ++i) {
            logProcs.add(new CentralProcessor.LogicalProcessor(i, coreMap.getOrDefault(i, 0), packageMap.getOrDefault(i, 0)));
        }
        return logProcs;
    }

    @Override
    protected long queryContextSwitches() {
        return this.vmStats.get().getA();
    }

    @Override
    protected long queryInterrupts() {
        return this.vmStats.get().getB();
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<Long, Long> queryVmStats() {
        void var2_1;
        void var0;
        long contextSwitches = 0L;
        long interrupts = 0L;
        Object object = ExecutingCommand.runNative("vmstat -s");
        object = object.iterator();
        while (object.hasNext()) {
            String line = (String)object.next();
            if (line.endsWith("cpu context switches")) {
                contextSwitches = ParseUtil.getFirstIntValue(line);
                continue;
            }
            if (!line.endsWith("interrupts")) continue;
            interrupts = ParseUtil.getFirstIntValue(line);
        }
        return new Pair<Long, Long>((long)var0, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long[] querySystemCpuLoadTicks() {
        void var1_1;
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        int[] nArray = new int[2];
        Object mib = nArray;
        nArray[0] = 1;
        mib[1] = 40;
        Memory memory = OpenBsdSysctlUtil.sysctl(mib);
        mib = memory;
        long[] cpuTicks = OpenBsdCentralProcessor.cpTimeToTicks(memory, false);
        if (cpuTicks.length >= 5) {
            void var3_3;
            void var2_2;
            ticks[CentralProcessor.TickType.USER.getIndex()] = cpuTicks[0];
            ticks[CentralProcessor.TickType.NICE.getIndex()] = cpuTicks[1];
            ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpuTicks[2];
            int offset = cpuTicks.length > 5 ? 1 : 0;
            ticks[CentralProcessor.TickType.IRQ.getIndex()] = cpuTicks[offset + 3];
            ticks[CentralProcessor.TickType.IDLE.getIndex()] = var2_2[var3_3 + 4];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long[][] queryProcessorCpuLoadTicks() {
        void var1_1;
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int[] nArray = new int[3];
        int[] mib = nArray;
        nArray[0] = 1;
        mib[1] = 71;
        for (int cpu = 0; cpu < this.getLogicalProcessorCount(); ++cpu) {
            mib[2] = cpu;
            Memory memory = OpenBsdSysctlUtil.sysctl(mib);
            long[] cpuTicks = OpenBsdCentralProcessor.cpTimeToTicks(memory, true);
            if (cpuTicks.length < 5) continue;
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = cpuTicks[0];
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = cpuTicks[1];
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = cpuTicks[2];
            int offset = cpuTicks.length > 5 ? 1 : 0;
            ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = cpuTicks[offset + 3];
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = cpuTicks[offset + 4];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static long[] cpTimeToTicks(Memory m, boolean force64bit) {
        void var1_2;
        int arraySize;
        long longBytes = force64bit ? 8L : (long)Native.LONG_SIZE;
        int n = arraySize = m == null ? 0 : (int)(m.size() / longBytes);
        if (force64bit && m != null) {
            return m.getLongArray(0L, arraySize);
        }
        long[] ticks = new long[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            ticks[i] = m.getNativeLong((long)i * longBytes).longValue();
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] getSystemLoadAverage(int nelem) {
        void var2_2;
        void var1_1;
        if (nelem <= 0 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int n = OpenBsdLibc.INSTANCE.getloadavg(average, nelem);
        if (n < var1_1) {
            Arrays.fill(average, -1.0);
        }
        return var2_2;
    }
}

