/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.unix.solaris.SolarisLibc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

@ThreadSafe
final class SolarisCentralProcessor
extends AbstractCentralProcessor {
    private static final String CPU_INFO = "cpu_info";

    SolarisCentralProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final CentralProcessor.ProcessorIdentifier queryProcessorId() {
        void var3_4;
        void var2_3;
        void var1_1;
        String cpuVendor = "";
        String cpuName = "";
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        long cpuFreq = 0L;
        try (KstatUtil.KstatChain kc = KstatUtil.openChain();){
            LibKstat.Kstat ksp = KstatUtil.KstatChain.lookup(CPU_INFO, -1, null);
            if (ksp != null && KstatUtil.KstatChain.read(ksp)) {
                cpuVendor = KstatUtil.dataLookupString(ksp, "vendor_id");
                cpuName = KstatUtil.dataLookupString(ksp, "brand");
                cpuFamily = KstatUtil.dataLookupString(ksp, "family");
                cpuModel = KstatUtil.dataLookupString(ksp, "model");
                cpuStepping = KstatUtil.dataLookupString(ksp, "stepping");
                cpuFreq = KstatUtil.dataLookupLong(ksp, "clock_MHz") * 1000000L;
            }
        }
        boolean cpu64bit = "64".equals(ExecutingCommand.getFirstAnswer("isainfo -b").trim());
        String processorID = SolarisCentralProcessor.getProcessorID(cpuStepping, cpuModel, cpuFamily);
        return new CentralProcessor.ProcessorIdentifier((String)var1_1, (String)var2_3, (String)var3_4, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        void var2_2;
        Map<Integer, Integer> numaNodeMap = SolarisCentralProcessor.mapNumaNodes();
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        KstatUtil.KstatChain kc = KstatUtil.openChain();
        try {
            List<LibKstat.Kstat> list = KstatUtil.KstatChain.lookupAll(CPU_INFO, -1, null);
            for (LibKstat.Kstat ksp : list) {
                if (ksp == null || !KstatUtil.KstatChain.read(ksp)) continue;
                int procId = logProcs.size();
                String chipId = KstatUtil.dataLookupString(ksp, "chip_id");
                String coreId = KstatUtil.dataLookupString(ksp, "core_id");
                CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(procId, ParseUtil.parseIntOrDefault(coreId, 0), ParseUtil.parseIntOrDefault(chipId, 0), numaNodeMap.getOrDefault(procId, 0));
                logProcs.add(logProc);
            }
            if (kc != null) {
                kc.close();
            }
        }
        catch (Throwable throwable) {
            if (kc != null) {
                try {
                    void var3_3;
                    var3_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        if (logProcs.isEmpty()) {
            logProcs.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Integer, Integer> mapNumaNodes() {
        void var0;
        HashMap<Integer, Integer> numaNodeMap = new HashMap<Integer, Integer>();
        int lgroup = 0;
        for (String line : ExecutingCommand.runNative("lgrpinfo -c leaves")) {
            Iterator<Integer> iterator;
            if (line.startsWith("lgroup")) {
                lgroup = ParseUtil.getFirstIntValue(line);
                continue;
            }
            if (!line.contains("CPUs:") && !line.contains("CPU:")) continue;
            for (Integer cpu : ParseUtil.parseHyphenatedIntList(((String)((Object)iterator)).split(":")[1])) {
                numaNodeMap.put(cpu, lgroup);
            }
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] querySystemCpuLoadTicks() {
        void var1_1;
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        long[][] procTicks = this.getProcessorCpuLoadTicks();
        int i = 0;
        while (i < ticks.length) {
            long[][] lArray = procTicks;
            int n = procTicks.length;
            for (int j = 0; j < n; ++j) {
                long[] procTick = lArray[j];
                int n2 = i;
                ticks[n2] = ticks[n2] + procTick[i];
            }
            int n3 = i++;
            ticks[n3] = ticks[n3] / (long)procTicks.length;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] queryCurrentFreq() {
        void var1_1;
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, -1L);
        KstatUtil.KstatChain kc = KstatUtil.openChain();
        try {
            for (int i = 0; i < freqs.length; ++i) {
                for (LibKstat.Kstat ksp : KstatUtil.KstatChain.lookupAll(CPU_INFO, i, null)) {
                    if (!KstatUtil.KstatChain.read(ksp)) continue;
                    freqs[i] = KstatUtil.dataLookupLong(ksp, "current_clock_Hz");
                }
            }
            if (kc != null) {
                kc.close();
            }
        }
        catch (Throwable throwable) {
            if (kc != null) {
                try {
                    void var2_2;
                    var2_2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryMaxFreq() {
        void var1_1;
        long max = -1L;
        KstatUtil.KstatChain kc = KstatUtil.openChain();
        try {
            for (LibKstat.Kstat ksp : KstatUtil.KstatChain.lookupAll(CPU_INFO, 0, null)) {
                String suppFreq;
                if (!KstatUtil.KstatChain.read(ksp) || (suppFreq = KstatUtil.dataLookupString(ksp, "supported_frequencies_Hz")).isEmpty()) continue;
                for (String string : suppFreq.split(":")) {
                    long freq = ParseUtil.parseLongOrDefault(string, -1L);
                    if (max >= freq) continue;
                    max = freq;
                }
            }
            if (kc != null) {
                kc.close();
            }
        }
        catch (Throwable throwable) {
            if (kc != null) {
                try {
                    void var3_2;
                    var3_2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double[] getSystemLoadAverage(int nelem) {
        void var2_2;
        if (nelem <= 0 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = SolarisLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < nelem; ++i) {
                average[i] = -1.0;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[][] queryProcessorCpuLoadTicks() {
        void var1_1;
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int cpu = -1;
        KstatUtil.KstatChain kc = KstatUtil.openChain();
        try {
            for (LibKstat.Kstat ksp : KstatUtil.KstatChain.lookupAll("cpu", -1, "sys")) {
                if (++cpu >= ticks.length) break;
                if (!KstatUtil.KstatChain.read(ksp)) continue;
                ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = KstatUtil.dataLookupLong(ksp, "cpu_ticks_idle");
                ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatUtil.dataLookupLong(ksp, "cpu_ticks_kernel");
                ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = KstatUtil.dataLookupLong(ksp, "cpu_ticks_user");
            }
            if (kc != null) {
                kc.close();
            }
        }
        catch (Throwable throwable) {
            if (kc != null) {
                try {
                    void var3_3;
                    var3_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getProcessorID(String stepping, String model, String family) {
        void var2_2;
        void var1_1;
        String string;
        String line;
        Iterator iterator;
        List<String> isainfo = ExecutingCommand.runNative("isainfo -v");
        StringBuilder flags = new StringBuilder();
        iterator = iterator.iterator();
        while (iterator.hasNext() && !(line = (String)iterator.next()).startsWith("32-bit")) {
            if (line.startsWith("64-bit")) continue;
            flags.append(' ').append(line.trim());
        }
        return SolarisCentralProcessor.createProcessorID(string, (String)var1_1, (String)var2_2, ParseUtil.whitespaces.split(flags.toString().toLowerCase()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryContextSwitches() {
        void var1_1;
        long swtch = 0L;
        Object object = ExecutingCommand.runNative("kstat -p cpu_stat:::/pswitch\\\\|inv_swtch/");
        object = object.iterator();
        while (object.hasNext()) {
            String s = (String)object.next();
            swtch += ParseUtil.parseLastLong(s, 0L);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryInterrupts() {
        void var1_1;
        long intr = 0L;
        Object object = ExecutingCommand.runNative("kstat -p cpu_stat:::/intr/");
        object = object.iterator();
        while (object.hasNext()) {
            String s = (String)object.next();
            intr += ParseUtil.parseLastLong(s, 0L);
        }
        return (long)var1_1;
    }
}

