/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.GraphicsCard;
import oshi.hardware.common.AbstractGraphicsCard;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
final class SolarisGraphicsCard
extends AbstractGraphicsCard {
    private static final String PCI_CLASS_DISPLAY = "0003";

    /*
     * WARNING - void declaration
     */
    SolarisGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super((String)var1_1, (String)var2_2, (String)var3_3, versionInfo, vram);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<GraphicsCard> getGraphicsCards() {
        void var0;
        Iterator iterator;
        ArrayList<GraphicsCard> cardList = new ArrayList<GraphicsCard>();
        List<String> devices = ExecutingCommand.runNative("prtconf -pv");
        if (devices.isEmpty()) {
            return cardList;
        }
        String name = "";
        String vendorId = "";
        String productId = "";
        String classCode = "";
        ArrayList<String> versionInfoList = new ArrayList<String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (line.contains("Node 0x")) {
                if (PCI_CLASS_DISPLAY.equals(classCode)) {
                    cardList.add(new SolarisGraphicsCard(name.isEmpty() ? "unknown" : name, productId.isEmpty() ? "unknown" : productId, vendorId.isEmpty() ? "unknown" : vendorId, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), 0L));
                }
                name = "";
                vendorId = "unknown";
                productId = "unknown";
                classCode = "";
                versionInfoList.clear();
                continue;
            }
            String[] split = line.trim().split(":", 2);
            if (split.length != 2) continue;
            if (split[0].equals("model")) {
                name = ParseUtil.getSingleQuoteStringValue(line);
                continue;
            }
            if (split[0].equals("name")) {
                if (!name.isEmpty()) continue;
                name = ParseUtil.getSingleQuoteStringValue(line);
                continue;
            }
            if (split[0].equals("vendor-id")) {
                String string = line;
                vendorId = "0x" + string.substring(string.length() - 4);
                continue;
            }
            if (split[0].equals("device-id")) {
                String string = line;
                productId = "0x" + string.substring(string.length() - 4);
                continue;
            }
            if (split[0].equals("revision-id")) {
                versionInfoList.add(line.trim());
                continue;
            }
            if (!split[0].equals("class-code")) continue;
            String string = line;
            classCode = string.substring(string.length() - 8, line.length() - 4);
        }
        if (PCI_CLASS_DISPLAY.equals(classCode)) {
            void var3_3;
            void var2_2;
            cardList.add(new SolarisGraphicsCard((String)(name.isEmpty() ? "unknown" : var2_2), productId.isEmpty() ? "unknown" : productId, (String)(vendorId.isEmpty() ? "unknown" : var3_3), versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), 0L));
        }
        return var0;
    }
}

