/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.solaris.disk.Iostat;
import oshi.driver.unix.solaris.disk.Lshal;
import oshi.driver.unix.solaris.disk.Prtvtoc;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.common.AbstractHWDiskStore;
import oshi.util.platform.unix.solaris.KstatUtil;
import oshi.util.tuples.Quintet;

@ThreadSafe
public final class SolarisHWDiskStore
extends AbstractHWDiskStore {
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private long timeStamp = 0L;
    private List<HWPartition> partitionList;

    /*
     * WARNING - void declaration
     */
    private SolarisHWDiskStore(String name, String model, String serial, long size) {
        super((String)var1_1, (String)var2_2, (String)var3_3, size);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final long getReads() {
        return this.reads;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getWrites() {
        return this.writes;
    }

    @Override
    public final long getWriteBytes() {
        return this.writeBytes;
    }

    @Override
    public final long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    @Override
    public final long getTransferTime() {
        return this.transferTime;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public final List<HWPartition> getPartitions() {
        return this.partitionList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean updateAttributes() {
        KstatUtil.KstatChain kc = KstatUtil.openChain();
        try {
            LibKstat.Kstat ksp = KstatUtil.KstatChain.lookup(null, 0, this.getName());
            if (ksp != null && KstatUtil.KstatChain.read(ksp)) {
                void var2_2;
                void var3_4;
                LibKstat.KstatIO data = new LibKstat.KstatIO(ksp.ks_data);
                this.reads = data.reads;
                this.writes = data.writes;
                this.readBytes = data.nread;
                this.writeBytes = data.nwritten;
                this.currentQueueLength = (long)data.wcnt + (long)data.rcnt;
                this.transferTime = var3_4.rtime / 1000000L;
                this.timeStamp = var2_2.ks_snaptime / 1000000L;
                if (kc != null) {
                    kc.close();
                }
                return true;
            }
            if (kc != null) {
                kc.close();
            }
        }
        catch (Throwable throwable) {
            if (kc != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static List<HWDiskStore> getDisks() {
        void var3_3;
        Iterator iterator;
        Map<String, String> deviceMap = Iostat.queryPartitionToMountMap();
        Map<String, Integer> majorMap = Lshal.queryDiskToMajorMap();
        Map<String, Quintet<String, String, String, String, Long>> deviceStringMap = Iostat.queryDeviceStrings(deviceMap.keySet());
        ArrayList<SolarisHWDiskStore> storeList = new ArrayList<SolarisHWDiskStore>();
        for (Map.Entry entry : iterator.entrySet()) {
            String storeName = (String)entry.getKey();
            Quintet val = (Quintet)entry.getValue();
            storeList.add(SolarisHWDiskStore.createStore(storeName, (String)val.getA(), (String)val.getB(), (String)val.getC(), (String)val.getD(), (Long)val.getE(), deviceMap.getOrDefault(storeName, ""), majorMap.getOrDefault(storeName, 0)));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static SolarisHWDiskStore createStore(String diskName, String model, String vendor, String product, String serial, long size, String mount, int major) {
        SolarisHWDiskStore solarisHWDiskStore;
        void var1_1;
        void var3_3;
        void var2_2;
        SolarisHWDiskStore store = new SolarisHWDiskStore(diskName, (String)(model.isEmpty() ? ((String)var2_2 + " " + (String)var3_3).trim() : var1_1), serial, size);
        new SolarisHWDiskStore(diskName, (String)(model.isEmpty() ? ((String)var2_2 + " " + (String)var3_3).trim() : var1_1), serial, size).partitionList = Collections.unmodifiableList(Prtvtoc.queryPartitions(mount, major).stream().sorted(Comparator.comparing(HWPartition::getName)).collect(Collectors.toList()));
        store.updateAttributes();
        return solarisHWDiskStore;
    }
}

