/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
public class SolarisUsbDevice
extends AbstractUsbDevice {
    private static final String PCI_TYPE_USB = "000c";

    /*
     * WARNING - void declaration
     */
    public SolarisUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, String uniqueDeviceId, List<UsbDevice> connectedDevices) {
        super((String)var1_1, (String)var2_2, (String)var3_3, productId, serialNumber, uniqueDeviceId, connectedDevices);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<UsbDevice> getUsbDevices(boolean tree) {
        void var0_1;
        Iterator iterator;
        List<UsbDevice> devices = SolarisUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            UsbDevice device = (UsbDevice)iterator.next();
            deviceList.add(new SolarisUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), device.getUniqueDeviceId(), Collections.emptyList()));
            SolarisUsbDevice.addDevicesToList(deviceList, var2_3.getConnectedDevices());
        }
        return var0_1;
    }

    private static List<UsbDevice> getUsbDevices() {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> vendorIdMap = new HashMap<String, String>();
        HashMap<String, String> productIdMap = new HashMap<String, String>();
        HashMap<String, List<String>> hubMap = new HashMap<String, List<String>>();
        HashMap<String, String> deviceTypeMap = new HashMap<String, String>();
        List<String> devices = ExecutingCommand.runNative("prtconf -pv");
        if (devices.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Integer, String> lastParent = new HashMap<Integer, String>();
        String key = "";
        int indent = 0;
        ArrayList<String> usbControllers = new ArrayList<String>();
        for (String line : devices) {
            if (line.contains("Node 0x")) {
                key = line.replaceFirst("^\\s*", "");
                int depth = line.length() - key.length();
                if (indent == 0) {
                    indent = depth;
                }
                lastParent.put(depth, key);
                if (depth > indent) {
                    hubMap.computeIfAbsent((String)lastParent.get(depth - indent), x -> new ArrayList()).add(key);
                    continue;
                }
                usbControllers.add(key);
                continue;
            }
            if (key.isEmpty()) continue;
            if ((line = line.trim()).startsWith("model:")) {
                nameMap.put(key, ParseUtil.getSingleQuoteStringValue(line));
                continue;
            }
            if (line.startsWith("name:")) {
                nameMap.putIfAbsent(key, ParseUtil.getSingleQuoteStringValue(line));
                continue;
            }
            if (line.startsWith("vendor-id:")) {
                String string = line;
                vendorIdMap.put(key, string.substring(string.length() - 4));
                continue;
            }
            if (line.startsWith("device-id:")) {
                String string = line;
                productIdMap.put(key, string.substring(string.length() - 4));
                continue;
            }
            if (line.startsWith("class-code:")) {
                String string = line;
                deviceTypeMap.putIfAbsent(key, string.substring(string.length() - 8, line.length() - 4));
                continue;
            }
            if (!line.startsWith("device_type:")) continue;
            deviceTypeMap.putIfAbsent(key, ParseUtil.getSingleQuoteStringValue(line));
        }
        ArrayList<UsbDevice> controllerDevices = new ArrayList<UsbDevice>();
        for (String controller : usbControllers) {
            if (!PCI_TYPE_USB.equals(deviceTypeMap.getOrDefault(controller, "")) && !"usb".equals(deviceTypeMap.getOrDefault(controller, ""))) continue;
            controllerDevices.add(SolarisUsbDevice.getDeviceAndChildren(controller, "0000", "0000", nameMap, vendorIdMap, productIdMap, hubMap));
        }
        return controllerDevices;
    }

    /*
     * WARNING - void declaration
     */
    private static void addDevicesToList(List<UsbDevice> deviceList, List<UsbDevice> list) {
        for (UsbDevice device : list) {
            void var2_2;
            deviceList.add(device);
            SolarisUsbDevice.addDevicesToList(deviceList, var2_2.getConnectedDevices());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static SolarisUsbDevice getDeviceAndChildren(String devPath, String vid, String pid, Map<String, String> nameMap, Map<String, String> vendorIdMap, Map<String, String> productIdMap, Map<String, List<String>> hubMap) {
        String string;
        void var2_2;
        void var1_1;
        void var3_3;
        String vendorId = vendorIdMap.getOrDefault(devPath, vid);
        String productId = productIdMap.getOrDefault(devPath, pid);
        List childPaths = hubMap.getOrDefault(devPath, new ArrayList());
        ArrayList<UsbDevice> usbDevices = new ArrayList<UsbDevice>();
        for (String path : childPaths) {
            usbDevices.add(SolarisUsbDevice.getDeviceAndChildren(path, vendorId, productId, nameMap, vendorIdMap, productIdMap, hubMap));
        }
        Collections.sort(usbDevices);
        return new SolarisUsbDevice(var3_3.getOrDefault(devPath, vendorId + ":" + productId), "", (String)var1_1, (String)var2_2, "", string, usbDevices);
    }
}

