/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.solaris.kstat.SystemPages;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.hardware.platform.unix.solaris.SolarisGlobalMemory;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
final class SolarisVirtualMemory
extends AbstractVirtualMemory {
    private static final Pattern SWAP_INFO = Pattern.compile(".+\\s(\\d+)K\\s+(\\d+)K$");
    private final SolarisGlobalMemory global;
    private final Supplier<Pair<Long, Long>> availTotal = Memoizer.memoize(SystemPages::queryAvailableTotal, Memoizer.defaultExpiration());
    private final Supplier<Pair<Long, Long>> usedTotal = Memoizer.memoize(SolarisVirtualMemory::querySwapInfo, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesIn = Memoizer.memoize(SolarisVirtualMemory::queryPagesIn, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesOut = Memoizer.memoize(SolarisVirtualMemory::queryPagesOut, Memoizer.defaultExpiration());

    /*
     * WARNING - void declaration
     */
    SolarisVirtualMemory(SolarisGlobalMemory solarisGlobalMemory) {
        void var1_1;
        this.global = var1_1;
    }

    @Override
    public final long getSwapUsed() {
        return this.usedTotal.get().getA();
    }

    @Override
    public final long getSwapTotal() {
        return this.usedTotal.get().getB();
    }

    @Override
    public final long getVirtualMax() {
        return this.global.getPageSize() * this.availTotal.get().getB() + this.getSwapTotal();
    }

    @Override
    public final long getVirtualInUse() {
        return this.global.getPageSize() * (this.availTotal.get().getB() - this.availTotal.get().getA()) + this.getSwapUsed();
    }

    @Override
    public final long getSwapPagesIn() {
        return this.pagesIn.get();
    }

    @Override
    public final long getSwapPagesOut() {
        return this.pagesOut.get();
    }

    /*
     * WARNING - void declaration
     */
    private static long queryPagesIn() {
        void var0;
        long swapPagesIn = 0L;
        for (String s : ExecutingCommand.runNative("kstat -p cpu_stat:::pgswapin")) {
            void var3_2;
            swapPagesIn += ParseUtil.parseLastLong((String)var3_2, 0L);
        }
        return (long)var0;
    }

    /*
     * WARNING - void declaration
     */
    private static long queryPagesOut() {
        void var0;
        long swapPagesOut = 0L;
        for (String s : ExecutingCommand.runNative("kstat -p cpu_stat:::pgswapout")) {
            void var3_2;
            swapPagesOut += ParseUtil.parseLastLong((String)var3_2, 0L);
        }
        return (long)var0;
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<Long, Long> querySwapInfo() {
        void var0;
        void var2_1;
        long swapTotal = 0L;
        long swapUsed = 0L;
        String swap = ExecutingCommand.getAnswerAt("swap -lk", 1);
        Matcher m = SWAP_INFO.matcher(swap);
        if (m.matches()) {
            swapTotal = ParseUtil.parseLongOrDefault(m.group(1), 0L) << 10;
            swapUsed = swapTotal - (ParseUtil.parseLongOrDefault(m.group(2), 0L) << 10);
        }
        return new Pair<Long, Long>((long)var2_1, (long)var0);
    }
}

