/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.VersionHelpers;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworkIF;
import oshi.util.ParseUtil;

@ThreadSafe
public final class WindowsNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworkIF.class);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final byte CONNECTOR_PRESENT_BIT = 4;
    private int ifType;
    private int ndisPhysicalMediumType;
    private boolean connectorPresent;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;
    private String ifAlias;
    private NetworkIF.IfOperStatus ifOperStatus;

    /*
     * WARNING - void declaration
     */
    public WindowsNetworkIF(NetworkInterface netint) throws InstantiationException {
        super((NetworkInterface)var1_1);
        void var1_1;
        this.updateAttributes();
    }

    /*
     * WARNING - void declaration
     */
    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        void var1_2;
        boolean bl;
        ArrayList<WindowsNetworkIF> ifList = new ArrayList<WindowsNetworkIF>();
        for (NetworkInterface ni : WindowsNetworkIF.getNetworkInterfaces(bl)) {
            try {
                ifList.add(new WindowsNetworkIF(ni));
            }
            catch (InstantiationException e) {
                void var2_4;
                LOG.debug("Network Interface Instantiation failed: {}", (Object)var2_4.getMessage());
            }
        }
        return var1_2;
    }

    @Override
    public final int getIfType() {
        return this.ifType;
    }

    @Override
    public final int getNdisPhysicalMediumType() {
        return this.ndisPhysicalMediumType;
    }

    @Override
    public final boolean isConnectorPresent() {
        return this.connectorPresent;
    }

    @Override
    public final long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public final long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public final long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public final long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public final long getInErrors() {
        return this.inErrors;
    }

    @Override
    public final long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public final long getInDrops() {
        return this.inDrops;
    }

    @Override
    public final long getCollisions() {
        return this.collisions;
    }

    @Override
    public final long getSpeed() {
        return this.speed;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public final String getIfAlias() {
        return this.ifAlias;
    }

    @Override
    public final NetworkIF.IfOperStatus getIfOperStatus() {
        return this.ifOperStatus;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean updateAttributes() {
        if (IS_VISTA_OR_GREATER) {
            IPHlpAPI.MIB_IF_ROW2 ifRow = new IPHlpAPI.MIB_IF_ROW2();
            new IPHlpAPI.MIB_IF_ROW2().InterfaceIndex = this.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)this.queryNetworkInterface().getIndex(), (Object)this.getName());
                return false;
            }
            this.ifType = ifRow.Type;
            this.ndisPhysicalMediumType = ifRow.PhysicalMediumType;
            this.connectorPresent = (ifRow.InterfaceAndOperStatusFlags & 4) > 0;
            this.bytesSent = ifRow.OutOctets;
            this.bytesRecv = ifRow.InOctets;
            this.packetsSent = ifRow.OutUcastPkts;
            this.packetsRecv = ifRow.InUcastPkts;
            this.outErrors = ifRow.OutErrors;
            this.inErrors = ifRow.InErrors;
            this.collisions = ifRow.OutDiscards;
            this.inDrops = ifRow.InDiscards;
            this.speed = ifRow.ReceiveLinkSpeed;
            this.ifAlias = Native.toString((char[])ifRow.Alias);
            this.ifOperStatus = NetworkIF.IfOperStatus.byValue(ifRow.OperStatus);
        } else {
            void var1_2;
            IPHlpAPI.MIB_IFROW ifRow = new IPHlpAPI.MIB_IFROW();
            new IPHlpAPI.MIB_IFROW().dwIndex = this.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)this.queryNetworkInterface().getIndex(), (Object)this.getName());
                return false;
            }
            this.ifType = ifRow.dwType;
            this.bytesSent = ParseUtil.unsignedIntToLong(ifRow.dwOutOctets);
            this.bytesRecv = ParseUtil.unsignedIntToLong(ifRow.dwInOctets);
            this.packetsSent = ParseUtil.unsignedIntToLong(ifRow.dwOutUcastPkts);
            this.packetsRecv = ParseUtil.unsignedIntToLong(ifRow.dwInUcastPkts);
            this.outErrors = ParseUtil.unsignedIntToLong(ifRow.dwOutErrors);
            this.inErrors = ParseUtil.unsignedIntToLong(ifRow.dwInErrors);
            this.collisions = ParseUtil.unsignedIntToLong(ifRow.dwOutDiscards);
            this.inDrops = ParseUtil.unsignedIntToLong(ifRow.dwInDiscards);
            this.speed = ParseUtil.unsignedIntToLong(var1_2.dwSpeed);
            this.ifAlias = "";
            this.ifOperStatus = NetworkIF.IfOperStatus.UNKNOWN;
        }
        this.timeStamp = System.currentTimeMillis();
        return true;
    }
}

