/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.SoundCard;
import oshi.hardware.common.AbstractSoundCard;

@Immutable
final class WindowsSoundCard
extends AbstractSoundCard {
    private static final String REGISTRY_SOUNDCARDS = "SYSTEM\\CurrentControlSet\\Control\\Class\\{4d36e96c-e325-11ce-bfc1-08002be10318}\\";

    /*
     * WARNING - void declaration
     */
    WindowsSoundCard(String kernelVersion, String name, String codec) {
        super((String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<SoundCard> getSoundCards() {
        void var0;
        ArrayList<WindowsSoundCard> soundCards = new ArrayList<WindowsSoundCard>();
        String[] stringArray = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REGISTRY_SOUNDCARDS);
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String key = stringArray2[i];
            String fullKey = REGISTRY_SOUNDCARDS + key;
            try {
                if (!Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)fullKey, (String)"Driver")) continue;
                soundCards.add(new WindowsSoundCard(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)fullKey, (String)"Driver") + " " + Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)fullKey, (String)"DriverVersion"), Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)fullKey, (String)"ProviderName") + " " + Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)fullKey, (String)"DriverDesc"), Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)fullKey, (String)"DriverDesc")));
                continue;
            }
            catch (Win32Exception win32Exception) {
                Win32Exception e = win32Exception;
                if (win32Exception.getErrorCode() == 5) continue;
                throw e;
            }
        }
        return var0;
    }
}

