/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.perfmon.MemoryInformation;
import oshi.driver.windows.perfmon.PagingFile;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.hardware.platform.windows.WindowsGlobalMemory;
import oshi.util.Memoizer;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
final class WindowsVirtualMemory
extends AbstractVirtualMemory {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsVirtualMemory.class);
    private final WindowsGlobalMemory global;
    private final Supplier<Long> used = Memoizer.memoize(WindowsVirtualMemory::querySwapUsed, Memoizer.defaultExpiration());
    private final Supplier<Triplet<Long, Long, Long>> totalVmaxVused = Memoizer.memoize(WindowsVirtualMemory::querySwapTotalVirtMaxVirtUsed, Memoizer.defaultExpiration());
    private final Supplier<Pair<Long, Long>> swapInOut = Memoizer.memoize(WindowsVirtualMemory::queryPageSwaps, Memoizer.defaultExpiration());

    /*
     * WARNING - void declaration
     */
    WindowsVirtualMemory(WindowsGlobalMemory windowsGlobalMemory) {
        void var1_1;
        this.global = var1_1;
    }

    @Override
    public final long getSwapUsed() {
        return this.global.getPageSize() * this.used.get();
    }

    @Override
    public final long getSwapTotal() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getA();
    }

    @Override
    public final long getVirtualMax() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getB();
    }

    @Override
    public final long getVirtualInUse() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getC();
    }

    @Override
    public final long getSwapPagesIn() {
        return this.swapInOut.get().getA();
    }

    @Override
    public final long getSwapPagesOut() {
        return this.swapInOut.get().getB();
    }

    private static long querySwapUsed() {
        return PagingFile.querySwapUsed().getOrDefault(PagingFile.PagingPercentProperty.PERCENTUSAGE, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<Long, Long, Long> querySwapTotalVirtMaxVirtUsed() {
        void var0;
        Psapi.PERFORMANCE_INFORMATION perfInfo;
        Psapi.PERFORMANCE_INFORMATION pERFORMANCE_INFORMATION = perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(pERFORMANCE_INFORMATION, pERFORMANCE_INFORMATION.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return new Triplet<Long, Long, Long>(0L, 0L, 0L);
        }
        return new Triplet<Long, Long, Long>(perfInfo.CommitLimit.longValue() - perfInfo.PhysicalTotal.longValue(), perfInfo.CommitLimit.longValue(), var0.CommitTotal.longValue());
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<Long, Long> queryPageSwaps() {
        void var0;
        Map<MemoryInformation.PageSwapProperty, Long> valueMap = MemoryInformation.queryPageSwaps();
        return new Pair<Long, Long>(valueMap.getOrDefault(MemoryInformation.PageSwapProperty.PAGESINPUTPERSEC, 0L), var0.getOrDefault(MemoryInformation.PageSwapProperty.PAGESOUTPUTPERSEC, 0L));
    }
}

