/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.os.OSProcess;
import oshi.util.Memoizer;

@ThreadSafe
public abstract class AbstractOSProcess
implements OSProcess {
    private final Supplier<Double> cumulativeCpuLoad = Memoizer.memoize(this::queryCumulativeCpuLoad, Memoizer.defaultExpiration());
    private int processID;

    /*
     * WARNING - void declaration
     */
    protected AbstractOSProcess(int pid) {
        void var1_1;
        this.processID = var1_1;
    }

    @Override
    public int getProcessID() {
        return this.processID;
    }

    @Override
    public double getProcessCpuLoadCumulative() {
        return this.cumulativeCpuLoad.get();
    }

    private double queryCumulativeCpuLoad() {
        if ((double)this.getUpTime() > 0.0) {
            return (double)(this.getKernelTime() + this.getUserTime()) / (double)this.getUpTime();
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getProcessCpuLoadBetweenTicks(OSProcess priorSnapshot) {
        if (priorSnapshot != null && this.processID == priorSnapshot.getProcessID() && this.getUpTime() > priorSnapshot.getUpTime()) {
            void var1_1;
            return (double)(this.getUserTime() - priorSnapshot.getUserTime() + this.getKernelTime() - priorSnapshot.getKernelTime()) / (double)(this.getUpTime() - var1_1.getUpTime());
        }
        return this.getProcessCpuLoadCumulative();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder("OSProcess@");
        builder.append(Integer.toHexString(this.hashCode()));
        builder.append("[processID=").append(this.processID);
        builder.append(", name=").append(this.getName()).append(']');
        return var1_1.toString();
    }
}

