/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface InternetProtocolStats {
    public TcpStats getTCPv4Stats();

    public TcpStats getTCPv6Stats();

    public UdpStats getUDPv4Stats();

    public UdpStats getUDPv6Stats();

    public List<IPConnection> getConnections();

    @Immutable
    public static final class IPConnection {
        private final String type;
        private final byte[] localAddress;
        private final int localPort;
        private final byte[] foreignAddress;
        private final int foreignPort;
        private final TcpState state;
        private final int transmitQueue;
        private final int receiveQueue;
        private int owningProcessId;

        /*
         * WARNING - void declaration
         */
        public IPConnection(String type, byte[] localAddress, int localPort, byte[] foreignAddress, int foreignPort, TcpState state, int transmitQueue, int receiveQueue, int owningProcessId) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.type = var1_1;
            void v0 = var2_2;
            this.localAddress = Arrays.copyOf((byte[])v0, ((void)v0).length);
            this.localPort = var3_3;
            this.foreignAddress = Arrays.copyOf(foreignAddress, foreignAddress.length);
            this.foreignPort = foreignPort;
            this.state = state;
            this.transmitQueue = transmitQueue;
            this.receiveQueue = receiveQueue;
            this.owningProcessId = owningProcessId;
        }

        public final String getType() {
            return this.type;
        }

        public final byte[] getLocalAddress() {
            return Arrays.copyOf(this.localAddress, this.localAddress.length);
        }

        public final int getLocalPort() {
            return this.localPort;
        }

        public final byte[] getForeignAddress() {
            return Arrays.copyOf(this.foreignAddress, this.foreignAddress.length);
        }

        public final int getForeignPort() {
            return this.foreignPort;
        }

        public final TcpState getState() {
            return this.state;
        }

        public final int getTransmitQueue() {
            return this.transmitQueue;
        }

        public final int getReceiveQueue() {
            return this.receiveQueue;
        }

        public final int getowningProcessId() {
            return this.owningProcessId;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var2_2;
            void var1_1;
            String localIp = "*";
            try {
                localIp = InetAddress.getByAddress(this.localAddress).toString();
            }
            catch (UnknownHostException unknownHostException) {}
            String foreignIp = "*";
            try {
                foreignIp = InetAddress.getByAddress(this.foreignAddress).toString();
            }
            catch (UnknownHostException unknownHostException) {}
            return "IPConnection [type=" + this.type + ", localAddress=" + (String)var1_1 + ", localPort=" + this.localPort + ", foreignAddress=" + (String)var2_2 + ", foreignPort=" + this.foreignPort + ", state=" + (Object)((Object)this.state) + ", transmitQueue=" + this.transmitQueue + ", receiveQueue=" + this.receiveQueue + ", owningProcessId=" + this.owningProcessId + "]";
        }
    }

    public static enum TcpState {
        UNKNOWN,
        CLOSED,
        LISTEN,
        SYN_SENT,
        SYN_RECV,
        ESTABLISHED,
        FIN_WAIT_1,
        FIN_WAIT_2,
        CLOSE_WAIT,
        CLOSING,
        LAST_ACK,
        TIME_WAIT,
        NONE;

    }

    @Immutable
    public static final class UdpStats {
        private final long datagramsSent;
        private final long datagramsReceived;
        private final long datagramsNoPort;
        private final long datagramsReceivedErrors;

        /*
         * WARNING - void declaration
         */
        public UdpStats(long datagramsSent, long datagramsReceived, long datagramsNoPort, long datagramsReceivedErrors) {
            void var3_2;
            void var1_1;
            this.datagramsSent = var1_1;
            this.datagramsReceived = var3_2;
            this.datagramsNoPort = datagramsNoPort;
            this.datagramsReceivedErrors = datagramsReceivedErrors;
        }

        public final long getDatagramsSent() {
            return this.datagramsSent;
        }

        public final long getDatagramsReceived() {
            return this.datagramsReceived;
        }

        public final long getDatagramsNoPort() {
            return this.datagramsNoPort;
        }

        public final long getDatagramsReceivedErrors() {
            return this.datagramsReceivedErrors;
        }

        public final String toString() {
            return "UdpStats [datagramsSent=" + this.datagramsSent + ", datagramsReceived=" + this.datagramsReceived + ", datagramsNoPort=" + this.datagramsNoPort + ", datagramsReceivedErrors=" + this.datagramsReceivedErrors + "]";
        }
    }

    @Immutable
    public static final class TcpStats {
        private final long connectionsEstablished;
        private final long connectionsActive;
        private final long connectionsPassive;
        private final long connectionFailures;
        private final long connectionsReset;
        private final long segmentsSent;
        private final long segmentsReceived;
        private final long segmentsRetransmitted;
        private final long inErrors;
        private final long outResets;

        /*
         * WARNING - void declaration
         */
        public TcpStats(long connectionsEstablished, long connectionsActive, long connectionsPassive, long connectionFailures, long connectionsReset, long segmentsSent, long segmentsReceived, long segmentsRetransmitted, long inErrors, long outResets) {
            void var3_3;
            void var1_1;
            this.connectionsEstablished = var1_1;
            this.connectionsActive = var3_3;
            this.connectionsPassive = connectionsPassive;
            this.connectionFailures = connectionFailures;
            this.connectionsReset = connectionsReset;
            this.segmentsSent = segmentsSent;
            this.segmentsReceived = segmentsReceived;
            this.segmentsRetransmitted = segmentsRetransmitted;
            this.inErrors = inErrors;
            this.outResets = outResets;
        }

        public final long getConnectionsEstablished() {
            return this.connectionsEstablished;
        }

        public final long getConnectionsActive() {
            return this.connectionsActive;
        }

        public final long getConnectionsPassive() {
            return this.connectionsPassive;
        }

        public final long getConnectionFailures() {
            return this.connectionFailures;
        }

        public final long getConnectionsReset() {
            return this.connectionsReset;
        }

        public final long getSegmentsSent() {
            return this.segmentsSent;
        }

        public final long getSegmentsReceived() {
            return this.segmentsReceived;
        }

        public final long getSegmentsRetransmitted() {
            return this.segmentsRetransmitted;
        }

        public final long getInErrors() {
            return this.inErrors;
        }

        public final long getOutResets() {
            return this.outResets;
        }

        public final String toString() {
            return "TcpStats [connectionsEstablished=" + this.connectionsEstablished + ", connectionsActive=" + this.connectionsActive + ", connectionsPassive=" + this.connectionsPassive + ", connectionFailures=" + this.connectionFailures + ", connectionsReset=" + this.connectionsReset + ", segmentsSent=" + this.segmentsSent + ", segmentsReceived=" + this.segmentsReceived + ", segmentsRetransmitted=" + this.segmentsRetransmitted + ", inErrors=" + this.inErrors + ", outResets=" + this.outResets + "]";
        }
    }
}

