/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.Who;
import oshi.driver.linux.proc.CpuStat;
import oshi.driver.linux.proc.ProcessStat;
import oshi.driver.linux.proc.UpTime;
import oshi.jna.platform.linux.LinuxLibc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OperatingSystem;
import oshi.software.os.linux.LinuxFileSystem;
import oshi.software.os.linux.LinuxInternetProtocolStats;
import oshi.software.os.linux.LinuxNetworkParams;
import oshi.software.os.linux.LinuxOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public class LinuxOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG;
    private static final String OS_RELEASE_LOG = "os-release: {}";
    private static final String LSB_RELEASE_A_LOG = "lsb_release -a: {}";
    private static final String LSB_RELEASE_LOG = "lsb-release: {}";
    private static final String RELEASE_DELIM = " release ";
    private static final String DOUBLE_QUOTES = "(?:^\")|(?:\"$)";
    private static final String FILENAME_PROPERTIES = "oshi.linux.filename.properties";
    private static final long USER_HZ;
    static final long BOOTTIME;
    private static final int[] PPID_INDEX;

    @Override
    public String queryManufacturer() {
        return "GNU/Linux";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        void var3_3;
        void var1_1;
        void var2_2;
        Triplet<String, String, String> familyVersionCodename = LinuxOperatingSystem.queryFamilyVersionCodenameFromReleaseFiles();
        String buildNumber = null;
        String[] procVersion = FileUtil.readFile(ProcPath.VERSION);
        if (!procVersion.isEmpty()) {
            String[] stringArray = ParseUtil.whitespaces.split(procVersion.get(0));
            procVersion = stringArray;
            procVersion = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = procVersion[i];
                if ("Linux".equals(s) || "version".equals(s)) continue;
                buildNumber = s;
                break;
            }
        }
        OperatingSystem.OSVersionInfo versionInfo = new OperatingSystem.OSVersionInfo(familyVersionCodename.getB(), familyVersionCodename.getC(), (String)var2_2);
        return new Pair<String, void>((String)var1_1.getA(), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness < 64 && ExecutingCommand.getFirstAnswer("uname -m").indexOf("64") == -1) {
            void var1_1;
            return (int)var1_1;
        }
        return 64;
    }

    @Override
    public FileSystem getFileSystem() {
        return new LinuxFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new LinuxInternetProtocolStats();
    }

    @Override
    public List<OSSession> getSessions() {
        if (USE_WHO_COMMAND) {
            return super.getSessions();
        }
        return Who.queryUtxent();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSProcess getProcess(int pid) {
        LinuxOSProcess proc = new LinuxOSProcess(pid);
        if (!proc.getState().equals((Object)OSProcess.State.INVALID)) {
            void var1_2;
            return var1_2;
        }
        return null;
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.queryChildProcesses(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        File[] pidFiles = ProcessStat.getPidFiles();
        if (parentPid >= 0) {
            return LinuxOperatingSystem.queryProcessList(LinuxOperatingSystem.getChildrenOrDescendants(LinuxOperatingSystem.getParentPidsFromProcFiles(pidFiles), parentPid, false));
        }
        HashSet<Integer> descendantPids = new HashSet<Integer>();
        for (void var5_7 : var2_3) {
            int pid = ParseUtil.parseIntOrDefault(var5_7.getName(), -2);
            if (pid == -2) continue;
            descendantPids.add(pid);
        }
        return LinuxOperatingSystem.queryProcessList((Set<Integer>)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        void var1_1;
        File[] fileArray = ProcessStat.getPidFiles();
        return LinuxOperatingSystem.queryProcessList(LinuxOperatingSystem.getChildrenOrDescendants(LinuxOperatingSystem.getParentPidsFromProcFiles(fileArray), (int)var1_1, true));
    }

    /*
     * WARNING - void declaration
     */
    private static List<OSProcess> queryProcessList(Set<Integer> descendantPids) {
        void var1_1;
        Iterator<Integer> iterator;
        ArrayList<void> procs = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            int pid = (Integer)iterator.next();
            LinuxOSProcess proc = new LinuxOSProcess(pid);
            if (proc.getState().equals((Object)OSProcess.State.INVALID)) continue;
            procs.add(var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Integer, Integer> getParentPidsFromProcFiles(File[] pidFiles) {
        void var1_1;
        File[] fileArray;
        HashMap<Integer, Integer> parentPidMap = new HashMap<Integer, Integer>();
        for (File file : fileArray) {
            int pid = ParseUtil.parseIntOrDefault(file.getName(), 0);
            parentPidMap.put(pid, LinuxOperatingSystem.getParentPidFromProcFile(pid));
        }
        return var1_1;
    }

    private static int getParentPidFromProcFile(int pid) {
        long[] lArray;
        String stat = FileUtil.getStringFromFile(String.format("/proc/%d/stat", pid));
        if (stat.isEmpty()) {
            return 0;
        }
        lArray = ParseUtil.parseStringToLongArray((String)lArray, PPID_INDEX, ProcessStat.PROC_PID_STAT_LENGTH, ' ');
        return (int)lArray[0];
    }

    @Override
    public int getProcessId() {
        return LinuxLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcessStat.getPidFiles().length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getThreadCount() {
        try {
            LibC.Sysinfo info = new LibC.Sysinfo();
            if (0 != LibC.INSTANCE.sysinfo(info)) {
                LOG.error("Failed to get process thread count. Error code: {}", (Object)Native.getLastError());
                return 0;
            }
            return info.procs;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            void var1_2;
            LOG.error("Failed to get procs from sysinfo. {}", (Object)var1_2.getMessage());
            return 0;
        }
    }

    @Override
    public long getSystemUptime() {
        return (long)UpTime.getSystemUptimeSeconds();
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new LinuxNetworkParams();
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> queryFamilyVersionCodenameFromReleaseFiles() {
        void var0;
        void var1_1;
        Triplet<String, String, String> familyVersionCodename = LinuxOperatingSystem.readDistribRelease("/etc/system-release");
        if (familyVersionCodename != null) {
            return familyVersionCodename;
        }
        familyVersionCodename = LinuxOperatingSystem.readOsRelease();
        if (familyVersionCodename != null) {
            return familyVersionCodename;
        }
        familyVersionCodename = LinuxOperatingSystem.execLsbRelease();
        if (familyVersionCodename != null) {
            return familyVersionCodename;
        }
        familyVersionCodename = LinuxOperatingSystem.readLsbRelease();
        if (familyVersionCodename != null) {
            return familyVersionCodename;
        }
        String etcDistribRelease = LinuxOperatingSystem.getReleaseFilename();
        familyVersionCodename = LinuxOperatingSystem.readDistribRelease(etcDistribRelease);
        if (familyVersionCodename != null) {
            return familyVersionCodename;
        }
        String family = LinuxOperatingSystem.filenameToFamily(var1_1.replace("/etc/", "").replace("release", "").replace("version", "").replace("-", "").replace("_", ""));
        return new Triplet<void, String, String>(var0, "unknown", "unknown");
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> readOsRelease() {
        void var2_2;
        void var1_1;
        void var0;
        String family = null;
        String versionId = "unknown";
        String codeName = "unknown";
        Object object = FileUtil.readFile("/etc/os-release");
        object = object.iterator();
        while (object.hasNext()) {
            String line = (String)object.next();
            if (line.startsWith("VERSION=")) {
                LOG.debug(OS_RELEASE_LOG, (Object)line);
                line = line.replace("VERSION=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                String[] split = line.split("[()]");
                if (split.length <= 1) {
                    split = line.split(", ");
                }
                if (split.length > 0) {
                    versionId = split[0].trim();
                }
                if (split.length <= 1) continue;
                codeName = split[1].trim();
                continue;
            }
            if (line.startsWith("NAME=") && family == null) {
                LOG.debug(OS_RELEASE_LOG, (Object)line);
                family = line.replace("NAME=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                continue;
            }
            if (!line.startsWith("VERSION_ID=") || !versionId.equals("unknown")) continue;
            LOG.debug(OS_RELEASE_LOG, (Object)line);
            versionId = line.replace("VERSION_ID=", "").replaceAll(DOUBLE_QUOTES, "").trim();
        }
        if (family == null) {
            return null;
        }
        return new Triplet<void, void, void>(var0, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> execLsbRelease() {
        void var2_2;
        void var1_1;
        void var0;
        String family = null;
        String versionId = "unknown";
        String codeName = "unknown";
        for (String line : ExecutingCommand.runNative("lsb_release -a")) {
            void var4_4;
            if (line.startsWith("Description:")) {
                LOG.debug(LSB_RELEASE_A_LOG, (Object)line);
                if (!(line = line.replace("Description:", "").trim()).contains(RELEASE_DELIM)) continue;
                Triplet<String, String, String> triplet = LinuxOperatingSystem.parseRelease(line, RELEASE_DELIM);
                family = triplet.getA();
                if (versionId.equals("unknown")) {
                    versionId = triplet.getB();
                }
                if (!codeName.equals("unknown")) continue;
                codeName = triplet.getC();
                continue;
            }
            if (var4_4.startsWith("Distributor ID:") && family == null) {
                LOG.debug(LSB_RELEASE_A_LOG, (Object)var4_4);
                family = var4_4.replace("Distributor ID:", "").trim();
                continue;
            }
            if (var4_4.startsWith("Release:") && versionId.equals("unknown")) {
                LOG.debug(LSB_RELEASE_A_LOG, (Object)var4_4);
                versionId = var4_4.replace("Release:", "").trim();
                continue;
            }
            if (!var4_4.startsWith("Codename:") || !codeName.equals("unknown")) continue;
            LOG.debug(LSB_RELEASE_A_LOG, (Object)var4_4);
            codeName = var4_4.replace("Codename:", "").trim();
        }
        if (family == null) {
            return null;
        }
        return new Triplet<void, void, void>(var0, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> readLsbRelease() {
        void var2_2;
        void var1_1;
        void var0;
        String family = null;
        String versionId = "unknown";
        String codeName = "unknown";
        Object object = FileUtil.readFile("/etc/lsb-release");
        object = object.iterator();
        while (object.hasNext()) {
            void var4_4;
            String line = (String)object.next();
            if (line.startsWith("DISTRIB_DESCRIPTION=")) {
                LOG.debug(LSB_RELEASE_LOG, (Object)line);
                if (!(line = line.replace("DISTRIB_DESCRIPTION=", "").replaceAll(DOUBLE_QUOTES, "").trim()).contains(RELEASE_DELIM)) continue;
                Triplet<String, String, String> triplet = LinuxOperatingSystem.parseRelease(line, RELEASE_DELIM);
                family = triplet.getA();
                if (versionId.equals("unknown")) {
                    versionId = triplet.getB();
                }
                if (!codeName.equals("unknown")) continue;
                codeName = triplet.getC();
                continue;
            }
            if (var4_4.startsWith("DISTRIB_ID=") && family == null) {
                LOG.debug(LSB_RELEASE_LOG, (Object)var4_4);
                family = var4_4.replace("DISTRIB_ID=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                continue;
            }
            if (var4_4.startsWith("DISTRIB_RELEASE=") && versionId.equals("unknown")) {
                LOG.debug(LSB_RELEASE_LOG, (Object)var4_4);
                versionId = var4_4.replace("DISTRIB_RELEASE=", "").replaceAll(DOUBLE_QUOTES, "").trim();
                continue;
            }
            if (!var4_4.startsWith("DISTRIB_CODENAME=") || !codeName.equals("unknown")) continue;
            LOG.debug(LSB_RELEASE_LOG, (Object)var4_4);
            codeName = var4_4.replace("DISTRIB_CODENAME=", "").replaceAll(DOUBLE_QUOTES, "").trim();
        }
        if (family == null) {
            return null;
        }
        return new Triplet<void, void, void>(var0, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> readDistribRelease(String filename) {
        if (new File(filename).exists()) {
            Object object = FileUtil.readFile(filename);
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                String line = (String)object.next();
                LOG.debug("{}: {}", (Object)filename, (Object)line);
                if (line.contains(RELEASE_DELIM)) {
                    return LinuxOperatingSystem.parseRelease(line, RELEASE_DELIM);
                }
                if (!line.contains(" VERSION ")) continue;
                return LinuxOperatingSystem.parseRelease((String)var2_2, " VERSION ");
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> parseRelease(String line, String splitLine) {
        void var3_3;
        void var2_2;
        void var1_1;
        String[] split = line.split(splitLine);
        String family = split[0].trim();
        String versionId = "unknown";
        String codeName = "unknown";
        if (split.length > 1) {
            if ((split = split[1].split("[()]")).length > 0) {
                versionId = split[0].trim();
            }
            if (split.length > 1) {
                String[] stringArray;
                codeName = stringArray[1].trim();
            }
        }
        return new Triplet<void, void, void>(var1_1, var2_2, var3_3);
    }

    protected static String getReleaseFilename() {
        File file = new File("/etc");
        File[] matchingFiles = file.listFiles(f -> {
            File file;
            return (f.getName().endsWith("-release") || f.getName().endsWith("-version") || f.getName().endsWith("_release") || f.getName().endsWith("_version")) && !f.getName().endsWith("os-release") && !f.getName().endsWith("lsb-release") && !file.getName().endsWith("system-release");
        });
        if (matchingFiles != null && matchingFiles.length > 0) {
            return file[0].getPath();
        }
        if (new File("/etc/release").exists()) {
            return "/etc/release";
        }
        return "/etc/issue";
    }

    private static String filenameToFamily(String name) {
        String string;
        if (name.isEmpty()) {
            return "Solaris";
        }
        if ("issue".equalsIgnoreCase(name)) {
            return "Unknown";
        }
        Properties properties = FileUtil.readPropertiesFromFilename(FILENAME_PROPERTIES);
        String family = properties.getProperty(name.toLowerCase());
        if (family != null) {
            return properties;
        }
        return name.substring(0, 1).toUpperCase() + string.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSService[] getServices() {
        void var1_1;
        boolean s232;
        ArrayList<Object> services = new ArrayList<Object>();
        HashSet<String> running = new HashSet<String>();
        for (OSProcess oSProcess : this.getChildProcesses(1, OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.PID_ASC, 0)) {
            OSService s = new OSService(oSProcess.getName(), oSProcess.getProcessID(), OSService.State.RUNNING);
            services.add(s);
            running.add(oSProcess.getName());
        }
        boolean systemctlFound = false;
        List<String> list = ExecutingCommand.runNative("systemctl list-unit-files");
        for (String string : list) {
            String shortName;
            String[] split = ParseUtil.whitespaces.split(string);
            if (split.length < 2 || !split[0].endsWith(".service") || !"enabled".equals(split[1])) continue;
            String name2 = split[0].substring(0, split[0].length() - 8);
            int index = name2.lastIndexOf(46);
            String string2 = shortName = index < 0 || index > name2.length() - 2 ? name2 : name2.substring(index + 1);
            if (running.contains(name2) || running.contains(shortName)) continue;
            OSService s232 = new OSService(name2, 0, OSService.State.STOPPED);
            services.add(s232);
            s232 = true;
        }
        if (!s232) {
            File dir = new File("/etc/init");
            if (dir.exists() && dir.isDirectory()) {
                for (File f2 : dir.listFiles((f, name) -> name.toLowerCase().endsWith(".conf"))) {
                    void var3_7;
                    String shortName;
                    String name3 = f2.getName().substring(0, f2.getName().length() - 5);
                    int index = name3.lastIndexOf(46);
                    String string = shortName = index < 0 || index > name3.length() - 2 ? name3 : name3.substring(index + 1);
                    if (running.contains(name3) || running.contains(shortName)) continue;
                    OSService s3 = new OSService(name3, 0, OSService.State.STOPPED);
                    services.add(var3_7);
                }
            } else {
                LOG.error("Directory: /etc/init does not exist");
            }
        }
        return var1_1.toArray(new OSService[0]);
    }

    public static long getHz() {
        return USER_HZ;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        LOG = LoggerFactory.getLogger(LinuxOperatingSystem.class);
        USER_HZ = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf CLK_TCK"), 100L);
        long tempBT = CpuStat.getBootTime();
        if (tempBT == 0L) {
            tempBT = System.currentTimeMillis() / 1000L - (long)UpTime.getSystemUptimeSeconds();
        }
        BOOTTIME = var0;
        PPID_INDEX = new int[]{3};
    }
}

