/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Native;
import com.sun.jna.ptr.PointerByReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.mac.SystemB;
import oshi.jna.platform.unix.CLibrary;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
final class MacNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(MacNetworkParams.class);
    private static final SystemB SYS = SystemB.INSTANCE;
    private static final String IPV6_ROUTE_HEADER = "Internet6:";
    private static final String DEFAULT_GATEWAY = "default";

    MacNetworkParams() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getDomainName() {
        void var1_3;
        void var3_6;
        void var2_4;
        CLibrary.Addrinfo hint = new CLibrary.Addrinfo();
        new CLibrary.Addrinfo().ai_flags = 2;
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unknown host exception when getting address of local host: {}", (Object)e.getMessage());
            return "";
        }
        PointerByReference ptr = new PointerByReference();
        int res22 = SYS.getaddrinfo((String)var2_4, null, hint, ptr);
        if (res22 > 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed getaddrinfo(): {}", (Object)SYS.gai_strerror(res22));
            }
            return "";
        }
        CLibrary.Addrinfo res22 = new CLibrary.Addrinfo(ptr.getValue());
        String canonname = res22.ai_canonname.trim();
        SYS.freeaddrinfo(var3_6.getValue());
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getHostName() {
        void var1_1;
        byte[] hostnameBuffer = new byte[256];
        if (0 != SYS.gethostname(hostnameBuffer, 256)) {
            return super.getHostName();
        }
        return Native.toString((byte[])var1_1);
    }

    @Override
    public final String getIpv4DefaultGateway() {
        return MacNetworkParams.searchGateway(ExecutingCommand.runNative("route -n get default"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getIpv6DefaultGateway() {
        Iterator iterator;
        List<String> lines = ExecutingCommand.runNative("netstat -nr");
        boolean v6Table = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String line = (String)iterator.next();
            if (v6Table && line.startsWith(DEFAULT_GATEWAY)) {
                String[] fields = ParseUtil.whitespaces.split(line);
                if (fields.length <= 2 || !fields[2].contains("G")) continue;
                return var3_3[1].split("%")[0];
            }
            if (!var3_3.startsWith(IPV6_ROUTE_HEADER)) continue;
            v6Table = true;
        }
        return "";
    }
}

