/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.aix;

import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractOSFileStore;
import oshi.software.os.OSFileStore;
import oshi.software.os.unix.aix.AixFileSystem;

@ThreadSafe
public class AixOSFileStore
extends AbstractOSFileStore {
    private String logicalVolume;
    private String description;
    private String fsType;
    private long freeSpace;
    private long usableSpace;
    private long totalSpace;
    private long freeInodes;
    private long totalInodes;

    /*
     * WARNING - void declaration
     */
    public AixOSFileStore(String name, String volume, String label, String mount, String options, String uuid, String logicalVolume, String description, String fsType, long freeSpace, long usableSpace, long totalSpace, long freeInodes, long totalInodes) {
        super((String)var1_1, (String)var2_2, (String)var3_3, mount, options, uuid);
        void var3_3;
        void var2_2;
        void var1_1;
        this.logicalVolume = logicalVolume;
        this.description = description;
        this.fsType = fsType;
        this.freeSpace = freeSpace;
        this.usableSpace = usableSpace;
        this.totalSpace = totalSpace;
        this.freeInodes = freeInodes;
        this.totalInodes = totalInodes;
    }

    @Override
    public String getLogicalVolume() {
        return this.logicalVolume;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.fsType;
    }

    @Override
    public long getFreeSpace() {
        return this.freeSpace;
    }

    @Override
    public long getUsableSpace() {
        return this.usableSpace;
    }

    @Override
    public long getTotalSpace() {
        return this.totalSpace;
    }

    @Override
    public long getFreeInodes() {
        return this.freeInodes;
    }

    @Override
    public long getTotalInodes() {
        return this.totalInodes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateAttributes() {
        for (OSFileStore fileStore : AixFileSystem.getFileStoreMatching(this.getName())) {
            void var2_2;
            if (!this.getVolume().equals(fileStore.getVolume()) || !this.getMount().equals(fileStore.getMount())) continue;
            this.logicalVolume = fileStore.getLogicalVolume();
            this.description = fileStore.getDescription();
            this.fsType = fileStore.getType();
            this.freeSpace = fileStore.getFreeSpace();
            this.usableSpace = fileStore.getUsableSpace();
            this.totalSpace = fileStore.getTotalSpace();
            this.freeInodes = fileStore.getFreeInodes();
            this.totalInodes = var2_2.getTotalInodes();
            return true;
        }
        return false;
    }
}

