/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.aix;

import java.util.Iterator;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractOSThread;
import oshi.software.os.OSProcess;
import oshi.software.os.unix.aix.AixOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public class AixOSThread
extends AbstractOSThread {
    private int threadId;
    private OSProcess.State state = OSProcess.State.INVALID;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    /*
     * WARNING - void declaration
     */
    public AixOSThread(int pid, String[] split) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this.updateAttributes((String[])var2_2);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateAttributes() {
        List<String> threadListInfoPs = ExecutingCommand.runNative("ps -m -o THREAD -p " + this.getOwningProcessId());
        if (threadListInfoPs.size() > 2) {
            Iterator iterator;
            threadListInfoPs.remove(0);
            threadListInfoPs.remove(0);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                void var2_2;
                String threadInfo = (String)iterator.next();
                String[] threadInfoSplit = ParseUtil.whitespaces.split(threadInfo.trim());
                if (threadInfoSplit.length != 13 || !threadInfoSplit[3].equals(String.valueOf(this.getThreadId()))) continue;
                String[] stringArray = new String[3];
                String[] split = stringArray;
                stringArray[0] = threadInfoSplit[3];
                split[1] = threadInfoSplit[4];
                split[2] = var2_2[6];
                this.updateAttributes((String[])var3_3);
            }
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateAttributes(String[] split) {
        void var1_1;
        this.threadId = ParseUtil.parseIntOrDefault(split[0], 0);
        this.state = AixOSProcess.getStateFromOutput(split[1].charAt(0));
        this.priority = ParseUtil.parseIntOrDefault((String)var1_1[2], 0);
        return true;
    }
}

