/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.aix;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.aix.Uptime;
import oshi.driver.unix.aix.Who;
import oshi.driver.unix.aix.perfstat.PerfstatConfig;
import oshi.driver.unix.aix.perfstat.PerfstatProcess;
import oshi.jna.platform.unix.aix.AixLibc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.aix.AixFileSystem;
import oshi.software.os.unix.aix.AixInternetProtocolStats;
import oshi.software.os.unix.aix.AixNetworkParams;
import oshi.software.os.unix.aix.AixOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.tuples.Pair;

@ThreadSafe
public class AixOperatingSystem
extends AbstractOperatingSystem {
    private final Supplier<Perfstat.perfstat_partition_config_t> config = Memoizer.memoize(PerfstatConfig::queryConfig);
    Supplier<Perfstat.perfstat_process_t[]> procCpu = Memoizer.memoize(PerfstatProcess::queryProcesses, Memoizer.defaultExpiration());
    private static final long BOOTTIME = AixOperatingSystem.querySystemBootTimeMillis() / 1000L;

    @Override
    public String queryManufacturer() {
        return "IBM";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        void var1_1;
        void var3_3;
        void var2_2;
        String releaseNumber;
        Perfstat.perfstat_partition_config_t cfg = this.config.get();
        String systemName = System.getProperty("os.name");
        String archName = System.getProperty("os.arch");
        String versionNumber = System.getProperty("os.version");
        if (Util.isBlank(versionNumber)) {
            versionNumber = ExecutingCommand.getFirstAnswer("oslevel");
        }
        if (Util.isBlank(releaseNumber = Native.toString((byte[])cfg.OSBuild))) {
            releaseNumber = ExecutingCommand.getFirstAnswer("oslevel -s");
        } else {
            int idx = releaseNumber.lastIndexOf(32);
            if (idx > 0 && idx < releaseNumber.length()) {
                releaseNumber = releaseNumber.substring(idx + 1);
            }
        }
        return new Pair<void, OperatingSystem.OSVersionInfo>(var2_2, new OperatingSystem.OSVersionInfo(versionNumber, (String)var3_3, (String)var1_1));
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness == 64) {
            return 64;
        }
        if ((this.config.get().conf & 0x800000) > 0) {
            return 64;
        }
        return 32;
    }

    @Override
    public FileSystem getFileSystem() {
        return new AixFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new AixInternetProtocolStats();
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.getProcessListFromPS("ps -A -o st,pid,ppid,user,uid,group,gid,thcount,pri,vsize,rssize,etime,time,comm,pagein,args", -1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = AixOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, false);
        return var2_3.stream().filter(arg_0 -> AixOperatingSystem.lambda$queryChildProcesses$0((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = AixOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, true);
        return var2_3.stream().filter(arg_0 -> AixOperatingSystem.lambda$queryDescendantProcesses$1((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSProcess getProcess(int pid) {
        void var1_2;
        List<OSProcess> procs = this.getProcessListFromPS("ps -o st,pid,ppid,user,uid,group,gid,thcount,pri,vsize,rssize,etime,time,comm,pagein,args -p ", pid);
        if (procs.isEmpty()) {
            return null;
        }
        return (OSProcess)var1_2.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private List<OSProcess> getProcessListFromPS(String psCommand, int pid) {
        void var3_3;
        void var1_1;
        Perfstat.perfstat_process_t[] perfstat = this.procCpu.get();
        List<String> procList = ExecutingCommand.runNative(psCommand + (pid < 0 ? "" : Integer.valueOf(pid)));
        if (procList.isEmpty() || procList.size() < 2) {
            return Collections.emptyList();
        }
        HashMap<Integer, Pair<Long, Long>> cpuMap = new HashMap<Integer, Pair<Long, Long>>();
        for (Perfstat.perfstat_process_t stat : perfstat) {
            cpuMap.put((int)stat.pid, new Pair<Long, Long>((long)stat.ucpu_time, (long)stat.scpu_time));
        }
        procList.remove(0);
        ArrayList<AixOSProcess> procs = new ArrayList<AixOSProcess>();
        for (String proc : var1_1) {
            String[] split = ParseUtil.whitespaces.split(proc.trim(), 16);
            if (split.length != 16) continue;
            procs.add(new AixOSProcess(pid < 0 ? ParseUtil.parseIntOrDefault(split[1], 0) : pid, split, cpuMap, this.procCpu));
        }
        return var3_3;
    }

    @Override
    public int getProcessId() {
        return AixLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return this.procCpu.get().length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getThreadCount() {
        void var1_1;
        long tc = 0L;
        for (Perfstat.perfstat_process_t proc : this.procCpu.get()) {
            tc += proc.num_threads;
        }
        return (int)var1_1;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    /*
     * WARNING - void declaration
     */
    private static long querySystemBootTimeMillis() {
        long bootTime = Who.queryBootTime();
        if (bootTime >= 1000L) {
            void var0;
            return (long)var0;
        }
        return System.currentTimeMillis() - Uptime.queryUpTime();
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new AixNetworkParams();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSService[] getServices() {
        void var1_1;
        void var2_2;
        File[] listFiles;
        File dir;
        ArrayList<OSService> services = new ArrayList<OSService>();
        List<String> systemServicesInfoList = ExecutingCommand.runNative("lssrc -a");
        if (systemServicesInfoList.size() > 1) {
            systemServicesInfoList.remove(0);
            for (String systemService : systemServicesInfoList) {
                String[] serviceSplit = ParseUtil.whitespaces.split(systemService.trim());
                if (systemService.contains("active")) {
                    if (serviceSplit.length == 4) {
                        services.add(new OSService(serviceSplit[0], ParseUtil.parseIntOrDefault(serviceSplit[2], 0), OSService.State.RUNNING));
                        continue;
                    }
                    if (serviceSplit.length != 3) continue;
                    services.add(new OSService(serviceSplit[0], ParseUtil.parseIntOrDefault(serviceSplit[1], 0), OSService.State.RUNNING));
                    continue;
                }
                if (!systemService.contains("inoperative")) continue;
                services.add(new OSService(serviceSplit[0], 0, OSService.State.STOPPED));
            }
        }
        if ((dir = new File("/etc/rc.d/init.d")).exists() && dir.isDirectory() && (listFiles = var2_2.listFiles()) != null) {
            void var3_4;
            for (void file : var3_4) {
                String installedService = ExecutingCommand.getFirstAnswer(file.getAbsolutePath() + " status");
                if (installedService.contains("running")) {
                    services.add(new OSService(file.getName(), ParseUtil.parseLastInt(installedService, 0), OSService.State.RUNNING));
                    continue;
                }
                services.add(new OSService(file.getName(), 0, OSService.State.STOPPED));
            }
        }
        return var1_1.toArray(new OSService[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryDescendantProcesses$1(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryChildProcesses$0(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }
}

