/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.freebsd.Who;
import oshi.jna.platform.unix.freebsd.FreeBsdLibc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.freebsd.FreeBsdFileSystem;
import oshi.software.os.unix.freebsd.FreeBsdInternetProtocolStats;
import oshi.software.os.unix.freebsd.FreeBsdNetworkParams;
import oshi.software.os.unix.freebsd.FreeBsdOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class FreeBsdOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdOperatingSystem.class);
    private static final long BOOTTIME = FreeBsdOperatingSystem.querySystemBootTime();

    @Override
    public String queryManufacturer() {
        return "Unix/BSD";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        void var2_2;
        void var1_1;
        String family = BsdSysctlUtil.sysctl("kern.ostype", "FreeBSD");
        String version = BsdSysctlUtil.sysctl("kern.osrelease", "");
        String string = BsdSysctlUtil.sysctl("kern.version", "");
        String buildNumber = string.split(":")[0].replace(family, "").replace(version, "").trim();
        return new Pair<void, OperatingSystem.OSVersionInfo>(var1_1, new OperatingSystem.OSVersionInfo((String)var2_2, null, string));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness < 64 && ExecutingCommand.getFirstAnswer("uname -m").indexOf("64") == -1) {
            void var1_1;
            return (int)var1_1;
        }
        return 64;
    }

    @Override
    public FileSystem getFileSystem() {
        return new FreeBsdFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new FreeBsdInternetProtocolStats();
    }

    @Override
    public List<OSSession> getSessions() {
        if (USE_WHO_COMMAND) {
            return super.getSessions();
        }
        return Who.queryUtxent();
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return FreeBsdOperatingSystem.getProcessListFromPS(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = FreeBsdOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, false);
        return var2_3.stream().filter(arg_0 -> FreeBsdOperatingSystem.lambda$queryChildProcesses$0((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = FreeBsdOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, true);
        return var2_3.stream().filter(arg_0 -> FreeBsdOperatingSystem.lambda$queryDescendantProcesses$1((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSProcess getProcess(int pid) {
        void var1_2;
        List<OSProcess> procs = FreeBsdOperatingSystem.getProcessListFromPS(pid);
        if (procs.isEmpty()) {
            return null;
        }
        return (OSProcess)var1_2.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private static List<OSProcess> getProcessListFromPS(int pid) {
        void var1_1;
        Iterator iterator;
        List<String> procList;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        String psCommand = "ps -awwxo state,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etimes,systime,time,comm,majflt,minflt,nvscw,nivscw,args";
        if (pid >= 0) {
            psCommand = psCommand + " -p " + pid;
        }
        if ((procList = ExecutingCommand.runNative(psCommand)).isEmpty() || procList.size() < 2) {
            return procs;
        }
        procList.remove(0);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String proc = (String)iterator.next();
            String[] split = ParseUtil.whitespaces.split(proc.trim(), 20);
            if (split.length != 20) continue;
            procs.add(new FreeBsdOSProcess(pid < 0 ? ParseUtil.parseIntOrDefault(split[1], 0) : pid, (String[])var3_3));
        }
        return var1_1;
    }

    @Override
    public int getProcessId() {
        return FreeBsdLibc.INSTANCE.getpid();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getProcessCount() {
        List<String> procList = ExecutingCommand.runNative("ps -axo pid");
        if (!procList.isEmpty()) {
            void var1_1;
            return var1_1.size() - 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getThreadCount() {
        void var1_1;
        int threads = 0;
        for (String proc : ExecutingCommand.runNative("ps -axo nlwp")) {
            void var3_3;
            threads += ParseUtil.parseIntOrDefault(var3_3.trim(), 0);
        }
        return (int)var1_1;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    /*
     * WARNING - void declaration
     */
    private static long querySystemBootTime() {
        void var0;
        FreeBsdLibc.Timeval tv = new FreeBsdLibc.Timeval();
        if (!BsdSysctlUtil.sysctl("kern.boottime", tv) || tv.tv_sec == 0L) {
            return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L);
        }
        return var0.tv_sec;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new FreeBsdNetworkParams();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSService[] getServices() {
        void var1_1;
        File[] listFiles;
        ArrayList<OSService> services = new ArrayList<OSService>();
        HashSet<String> running = new HashSet<String>();
        Iterator<OSProcess> iterator = this.getChildProcesses(1, OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.PID_ASC, 0).iterator();
        while (iterator.hasNext()) {
            OSProcess p = iterator.next();
            OSService s = new OSService(p.getName(), p.getProcessID(), OSService.State.RUNNING);
            services.add(s);
            running.add(p.getName());
        }
        File dir = new File("/etc/rc.d");
        if (dir.exists() && dir.isDirectory() && (listFiles = ((File)((Object)iterator)).listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                String name = file.getName();
                if (running.contains(name)) continue;
                OSService s = new OSService(name, 0, OSService.State.STOPPED);
                services.add(s);
            }
        } else {
            LOG.error("Directory: /etc/init does not exist");
        }
        return var1_1.toArray(new OSService[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryDescendantProcesses$1(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryChildProcesses$0(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }
}

