/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.openbsd.OpenBsdLibc;
import oshi.software.common.AbstractOSProcess;
import oshi.software.os.OSProcess;
import oshi.software.os.OSThread;
import oshi.software.os.unix.openbsd.OpenBsdOSThread;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.openbsd.FstatUtil;

@ThreadSafe
public class OpenBsdOSProcess
extends AbstractOSProcess {
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private String name;
    private String path = "";
    private String commandLine;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;

    /*
     * WARNING - void declaration
     */
    public OpenBsdOSProcess(int pid, String[] split) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this.updateThreadCount();
        this.updateAttributes((String[])var2_2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine;
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return FstatUtil.getCwd(this.getProcessID());
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getOpenFiles() {
        return FstatUtil.getOpenFiles(this.getProcessID());
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getAffinityMask() {
        void var1_1;
        long bitMask = 0L;
        String[] stringArray = ExecutingCommand.getFirstAnswer("cpuset -gp " + this.getProcessID());
        String[] split = stringArray.split(":");
        if (split.length > 1) {
            String[] stringArray2 = stringArray[1].split(",");
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                int bitToSet = ParseUtil.parseIntOrDefault(string.trim(), -1);
                if (bitToSet < 0) continue;
                bitMask |= 1L << bitToSet;
            }
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int queryBitness() {
        void var3_3;
        int[] nArray = new int[4];
        int[] mib = nArray;
        nArray[0] = 1;
        mib[1] = 14;
        mib[2] = 9;
        mib[3] = this.getProcessID();
        Memory abi = new Memory(32L);
        IntByReference size = new IntByReference(32);
        if (0 == OpenBsdLibc.INSTANCE.sysctl(mib, 4, (Pointer)abi, (IntByReference)var3_3, null, 0)) {
            void var1_1;
            void var2_2;
            String elf = var2_2.getString(0L);
            if (elf.contains("ELF32")) {
                return 32;
            }
            if (var1_1.contains("ELF64")) {
                return 64;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSThread> getThreadDetails() {
        void var1_1;
        Iterator iterator;
        List<String> threadList;
        ArrayList<OSThread> threads = new ArrayList<OSThread>();
        String psCommand = "ps -aHwwxo tid,state,etime,time,nivcsw,nvcsw,majflt,minflt,pri,args";
        if (this.getProcessID() >= 0) {
            psCommand = psCommand + " -p " + this.getProcessID();
        }
        if ((threadList = ExecutingCommand.runNative(psCommand)).isEmpty() || threadList.size() < 2) {
            return threads;
        }
        threadList.remove(0);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String thread = (String)iterator.next();
            String[] split = ParseUtil.whitespaces.split(thread.trim(), 10);
            if (split.length != 10) continue;
            threads.add(new OpenBsdOSThread(this.getProcessID(), (String[])var3_3));
        }
        return var1_1;
    }

    @Override
    public long getMinorFaults() {
        return this.minorFaults;
    }

    @Override
    public long getMajorFaults() {
        return this.majorFaults;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public boolean updateAttributes() {
        String[] split;
        String string = "ps -awwxo state,pid,ppid,user,uid,group,gid,pri,vsz,rss,etime,cputime,comm,majflt,minflt,args -p " + this.getProcessID();
        List<String> procList = ExecutingCommand.runNative(string);
        if (procList.size() > 1 && (split = ParseUtil.whitespaces.split(procList.get(1).trim(), 16)).length == 16) {
            this.updateThreadCount();
            return this.updateAttributes((String[])string);
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateAttributes(String[] split) {
        void var1_1;
        void var2_2;
        long now = System.currentTimeMillis();
        switch (split[0].charAt(0)) {
            case 'R': {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 'I': 
            case 'S': {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': 
            case 'L': 
            case 'U': {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.parentProcessID = ParseUtil.parseIntOrDefault(split[2], 0);
        this.user = split[3];
        this.userID = split[4];
        this.group = split[5];
        this.groupID = split[6];
        this.priority = ParseUtil.parseIntOrDefault(split[7], 0);
        this.virtualSize = ParseUtil.parseLongOrDefault(split[8], 0L) << 10;
        this.residentSetSize = ParseUtil.parseLongOrDefault(split[9], 0L) << 10;
        long elapsedTime = ParseUtil.parseDHMSOrDefault(split[10], 0L);
        this.upTime = elapsedTime < 1L ? 1L : elapsedTime;
        this.startTime = var2_2 - this.upTime;
        this.userTime = ParseUtil.parseDHMSOrDefault(split[11], 0L);
        this.kernelTime = 0L;
        this.path = split[12];
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.minorFaults = ParseUtil.parseLongOrDefault(split[13], 0L);
        this.majorFaults = ParseUtil.parseLongOrDefault(split[14], 0L);
        long nonVoluntaryContextSwitches = ParseUtil.parseLongOrDefault(split[15], 0L);
        long voluntaryContextSwitches = ParseUtil.parseLongOrDefault(split[16], 0L);
        this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        this.commandLine = var1_1[17];
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void updateThreadCount() {
        List<String> threadList = ExecutingCommand.runNative("ps -axHo tid -p " + this.getProcessID());
        if (!threadList.isEmpty()) {
            void var1_1;
            this.threadCount = var1_1.size() - 1;
        }
        this.threadCount = 1;
    }
}

