/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.openbsd;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.openbsd.OpenBsdLibc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.openbsd.OpenBsdFileSystem;
import oshi.software.os.unix.openbsd.OpenBsdInternetProtocolStats;
import oshi.software.os.unix.openbsd.OpenBsdNetworkParams;
import oshi.software.os.unix.openbsd.OpenBsdOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.openbsd.OpenBsdSysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class OpenBsdOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdOperatingSystem.class);
    private static final long BOOTTIME = OpenBsdOperatingSystem.querySystemBootTime();

    @Override
    public String queryManufacturer() {
        return "Unix/BSD";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        void var1_1;
        void var3_3;
        void var2_2;
        int[] nArray = new int[2];
        Object mib = nArray;
        nArray[0] = 1;
        mib[1] = 1;
        String family = OpenBsdSysctlUtil.sysctl(mib, "OpenBSD");
        mib[1] = 2;
        String version = OpenBsdSysctlUtil.sysctl(mib, "");
        mib[1] = 4;
        String string = OpenBsdSysctlUtil.sysctl(mib, "");
        mib = string;
        String buildNumber = string.split(":")[0].replace(family, "").replace(version, "").trim();
        return new Pair<void, OperatingSystem.OSVersionInfo>(var2_2, new OperatingSystem.OSVersionInfo((String)var3_3, null, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness < 64 && ExecutingCommand.getFirstAnswer("uname -m").indexOf("64") == -1) {
            void var1_1;
            return (int)var1_1;
        }
        return 64;
    }

    @Override
    public FileSystem getFileSystem() {
        return new OpenBsdFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new OpenBsdInternetProtocolStats();
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return OpenBsdOperatingSystem.getProcessListFromPS(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = OpenBsdOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, false);
        return var2_3.stream().filter(arg_0 -> OpenBsdOperatingSystem.lambda$queryChildProcesses$0((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = OpenBsdOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, true);
        return var2_3.stream().filter(arg_0 -> OpenBsdOperatingSystem.lambda$queryDescendantProcesses$1((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSProcess getProcess(int pid) {
        void var1_2;
        List<OSProcess> procs = OpenBsdOperatingSystem.getProcessListFromPS(pid);
        if (procs.isEmpty()) {
            return null;
        }
        return (OSProcess)var1_2.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private static List<OSProcess> getProcessListFromPS(int pid) {
        void var1_1;
        Iterator iterator;
        List<String> procList;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        String psCommand = "ps -awwxo state,pid,ppid,user,uid,group,gid,pri,vsz,rss,etime,cputime,comm,majflt,minflt,nvscw,nivscw,args";
        if (pid >= 0) {
            psCommand = psCommand + " -p " + pid;
        }
        if ((procList = ExecutingCommand.runNative(psCommand)).isEmpty() || procList.size() < 2) {
            return procs;
        }
        procList.remove(0);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String proc = (String)iterator.next();
            String[] split = ParseUtil.whitespaces.split(proc.trim(), 18);
            if (split.length != 18) continue;
            procs.add(new OpenBsdOSProcess(pid < 0 ? ParseUtil.parseIntOrDefault(split[1], 0) : pid, (String[])var3_3));
        }
        return var1_1;
    }

    @Override
    public int getProcessId() {
        return OpenBsdLibc.INSTANCE.getpid();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getProcessCount() {
        List<String> procList = ExecutingCommand.runNative("ps -axo pid");
        if (!procList.isEmpty()) {
            void var1_1;
            return var1_1.size() - 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getThreadCount() {
        List<String> threadList = ExecutingCommand.runNative("ps -axHo tid");
        if (!threadList.isEmpty()) {
            void var1_1;
            return var1_1.size() - 1;
        }
        return 0;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    private static long querySystemBootTime() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L);
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new OpenBsdNetworkParams();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSService[] getServices() {
        void var1_1;
        File[] listFiles;
        ArrayList<OSService> services = new ArrayList<OSService>();
        HashSet<String> running = new HashSet<String>();
        Iterator<OSProcess> iterator = this.getChildProcesses(1, OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.PID_ASC, 0).iterator();
        while (iterator.hasNext()) {
            OSProcess p = iterator.next();
            OSService s = new OSService(p.getName(), p.getProcessID(), OSService.State.RUNNING);
            services.add(s);
            running.add(p.getName());
        }
        File dir = new File("/etc/rc.d");
        if (dir.exists() && dir.isDirectory() && (listFiles = ((File)((Object)iterator)).listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                String name = file.getName();
                if (running.contains(name)) continue;
                OSService s = new OSService(name, 0, OSService.State.STOPPED);
                services.add(s);
            }
        } else {
            LOG.error("Directory: /etc/rc.d does not exist");
        }
        return var1_1.toArray(new OSService[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryDescendantProcesses$1(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryChildProcesses$0(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }
}

