/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractOSProcess;
import oshi.software.os.OSProcess;
import oshi.software.os.OSThread;
import oshi.software.os.unix.solaris.SolarisOSThread;
import oshi.util.ExecutingCommand;
import oshi.util.LsofUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;

@ThreadSafe
public class SolarisOSProcess
extends AbstractOSProcess {
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private String name;
    private String path = "";
    private String commandLine;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long contextSwitches;

    /*
     * WARNING - void declaration
     */
    public SolarisOSProcess(int pid, String[] split) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this.updateAttributes((String[])var2_2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine;
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return LsofUtil.getCwd(this.getProcessID());
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getOpenFiles() {
        return LsofUtil.getOpenFiles(this.getProcessID());
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    /*
     * WARNING - void declaration
     */
    private int queryBitness() {
        Object object = ExecutingCommand.runNative("pflags " + this.getProcessID());
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            String line = (String)object.next();
            if (!line.contains("data model")) continue;
            if (line.contains("LP32")) {
                return 32;
            }
            if (!var2_2.contains("LP64")) continue;
            return 64;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getAffinityMask() {
        void var1_1;
        long bitMask = 0L;
        Object cpuset = ExecutingCommand.getFirstAnswer("pbind -q " + this.getProcessID());
        if (((String)cpuset).isEmpty()) {
            cpuset = ExecutingCommand.runNative("psrinfo");
            cpuset = cpuset.iterator();
            while (cpuset.hasNext()) {
                String proc = cpuset.next();
                String[] stringArray = ParseUtil.whitespaces.split(proc);
                int bitToSet = ParseUtil.parseIntOrDefault(stringArray[0], -1);
                if (bitToSet < 0) continue;
                bitMask |= 1L << bitToSet;
            }
            return bitMask;
        }
        if (((String)cpuset).endsWith(".") && ((String)cpuset).contains("strongly bound to processor(s)")) {
            int bitToSet;
            String parse = ((String)cpuset).substring(0, ((String)cpuset).length() - 1);
            String[] split = ParseUtil.whitespaces.split(parse);
            for (int i = split.length - 1; i >= 0 && (bitToSet = ParseUtil.parseIntOrDefault(split[i], -1)) >= 0; --i) {
                bitMask |= 1L << bitToSet;
            }
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSThread> getThreadDetails() {
        void var2_2;
        List<String> threadListInfo1 = ExecutingCommand.runNative("ps -o lwp,s,etime,stime,time,addr,pri -p " + this.getProcessID());
        List<String> threadListInfo2 = ExecutingCommand.runNative("prstat -L -v -p " + this.getProcessID() + " 1 1");
        Map<Integer, String[]> threadMap = SolarisOSProcess.parseAndMergePSandPrstatInfo(threadListInfo1, 0, 7, (List<String>)var2_2, true);
        if (threadMap.keySet().size() > 1) {
            void var1_1;
            return var1_1.entrySet().stream().map(entry -> {
                void var1_1;
                return new SolarisOSThread(this.getProcessID(), (String[])var1_1.getValue());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateAttributes() {
        void var1_1;
        void var3_3;
        int pid = this.getProcessID();
        List<String> procList = ExecutingCommand.runNative("ps -o s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args -p " + pid);
        List<String> procList2 = ExecutingCommand.runNative("prstat -v -p " + pid + " 1 1");
        Map<Integer, String[]> processMap = SolarisOSProcess.parseAndMergePSandPrstatInfo(procList, 1, 15, (List<String>)var3_3, false);
        if (processMap.containsKey((int)var1_1)) {
            void var2_2;
            return this.updateAttributes((String[])var2_2.get(this.getProcessID()));
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateAttributes(String[] split) {
        void var1_1;
        void var2_2;
        long now = System.currentTimeMillis();
        this.state = SolarisOSProcess.getStateFromOutput(split[0].charAt(0));
        this.parentProcessID = ParseUtil.parseIntOrDefault(split[2], 0);
        this.user = split[3];
        this.userID = split[4];
        this.group = split[5];
        this.groupID = split[6];
        this.threadCount = ParseUtil.parseIntOrDefault(split[7], 0);
        this.priority = ParseUtil.parseIntOrDefault(split[8], 0);
        this.virtualSize = ParseUtil.parseLongOrDefault(split[9], 0L) << 10;
        this.residentSetSize = ParseUtil.parseLongOrDefault(split[10], 0L) << 10;
        long elapsedTime = ParseUtil.parseDHMSOrDefault(split[11], 0L);
        this.upTime = elapsedTime < 1L ? 1L : elapsedTime;
        this.startTime = var2_2 - this.upTime;
        this.kernelTime = 0L;
        this.userTime = ParseUtil.parseDHMSOrDefault(split[12], 0L);
        this.path = split[13];
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.commandLine = split[14];
        long nonVoluntaryContextSwitches = ParseUtil.parseLongOrDefault(split[15], 0L);
        long voluntaryContextSwitches = ParseUtil.parseLongOrDefault((String)var1_1[16], 0L);
        this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static Map<Integer, String[]> parseAndMergePSandPrstatInfo(List<String> psInfo, int psKeyIndex, int psLength, List<String> prstatInfo, boolean useTid) {
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        if (psInfo.size() > 1) {
            void var1_1;
            List<String> list;
            list.stream().skip(1L).forEach(arg_0 -> SolarisOSProcess.lambda$parseAndMergePSandPrstatInfo$1(psLength, (int)var1_1, map, arg_0));
            if (prstatInfo.size() > 1) {
                void var2_2;
                void var3_3;
                var3_3.stream().skip(1L).forEach(arg_0 -> SolarisOSProcess.lambda$parseAndMergePSandPrstatInfo$2(useTid, map, (int)var2_2, arg_0));
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    static OSProcess.State getStateFromOutput(char stateValue) {
        void var0_1;
        switch (stateValue) {
            case 'O': {
                OSProcess.State state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                OSProcess.State state = OSProcess.State.SLEEPING;
                break;
            }
            case 'R': 
            case 'W': {
                OSProcess.State state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                OSProcess.State state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                OSProcess.State state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                OSProcess.State state = OSProcess.State.OTHER;
            }
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$parseAndMergePSandPrstatInfo$2(boolean useTid, Map map, int psLength, String threadInfo) {
        String[] splitPrstat = ParseUtil.whitespaces.split(threadInfo.trim());
        if (splitPrstat.length == 15) {
            void var1_2;
            String[] existingSplit;
            int idxAfterForwardSlash;
            String id = splitPrstat[0];
            if (useTid && (idxAfterForwardSlash = splitPrstat[14].lastIndexOf(47) + 1) > 0 && idxAfterForwardSlash < splitPrstat[14].length()) {
                id = splitPrstat[14].substring(idxAfterForwardSlash);
            }
            if ((existingSplit = (String[])var1_2.get(Integer.parseInt(id))) != null) {
                void var3_4;
                existingSplit[psLength] = splitPrstat[10];
                var0_1[var2_3 + true] = var3_4[11];
            }
        }
    }

    private static /* synthetic */ void lambda$parseAndMergePSandPrstatInfo$1(int psLength, int psKeyIndex, Map map, String info) {
        String[] psSplit = ParseUtil.whitespaces.split(info.trim(), psLength);
        String[] mergedSplit = new String[psLength + 2];
        if (psSplit.length == psLength) {
            for (int idx = 0; idx < psLength; ++idx) {
                if (idx == psKeyIndex) {
                    map.put(ParseUtil.parseIntOrDefault(psSplit[idx], 0), mergedSplit);
                }
                mergedSplit[idx] = psSplit[idx];
            }
        }
    }
}

