/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.proc.ProcessStat;
import oshi.driver.unix.solaris.Who;
import oshi.jna.platform.unix.solaris.SolarisLibc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.solaris.SolarisFileSystem;
import oshi.software.os.unix.solaris.SolarisInternetProtocolStats;
import oshi.software.os.unix.solaris.SolarisNetworkParams;
import oshi.software.os.unix.solaris.SolarisOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class SolarisOperatingSystem
extends AbstractOperatingSystem {
    private static final String PS_FIELDS = "s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args";
    private static final String PROCESS_LIST_FOR_PID_COMMAND = "ps -o s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args -p ";
    private static final String PROCESS_LIST_COMMAND = "ps -eo s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args";
    private static final long BOOTTIME = SolarisOperatingSystem.querySystemBootTime();

    @Override
    public String queryManufacturer() {
        return "Oracle";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        void var3_3;
        void var2_2;
        String[] split = ParseUtil.whitespaces.split(ExecutingCommand.getFirstAnswer("uname -rv"));
        String version = split[0];
        Object buildNumber = null;
        if (split.length > 1) {
            void var1_1;
            buildNumber = var1_1[1];
        }
        return new Pair<String, OperatingSystem.OSVersionInfo>("SunOS", new OperatingSystem.OSVersionInfo((String)var2_2, "Solaris", (String)var3_3));
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness == 64) {
            return 64;
        }
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("isainfo -b"), 32);
    }

    @Override
    public FileSystem getFileSystem() {
        return new SolarisFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new SolarisInternetProtocolStats();
    }

    @Override
    public List<OSSession> getSessions() {
        if (USE_WHO_COMMAND) {
            return super.getSessions();
        }
        return Who.queryUtxent();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSProcess getProcess(int pid) {
        void var1_2;
        List<OSProcess> procs = SolarisOperatingSystem.getProcessListFromPS(PROCESS_LIST_FOR_PID_COMMAND, pid);
        if (procs.isEmpty()) {
            return null;
        }
        return (OSProcess)var1_2.get(0);
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return SolarisOperatingSystem.queryAllProcessesFromPS();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = SolarisOperatingSystem.queryAllProcessesFromPS();
        Set<Integer> descendantPids = SolarisOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, false);
        return var2_3.stream().filter(arg_0 -> SolarisOperatingSystem.lambda$queryChildProcesses$0((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        void var1_2;
        void var2_3;
        List<OSProcess> allProcs = SolarisOperatingSystem.queryAllProcessesFromPS();
        Set<Integer> descendantPids = SolarisOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, true);
        return var2_3.stream().filter(arg_0 -> SolarisOperatingSystem.lambda$queryDescendantProcesses$1((Set)var1_2, arg_0)).collect(Collectors.toList());
    }

    private static List<OSProcess> queryAllProcessesFromPS() {
        return SolarisOperatingSystem.getProcessListFromPS(PROCESS_LIST_COMMAND, -1);
    }

    /*
     * WARNING - void declaration
     */
    private static List<OSProcess> getProcessListFromPS(String psCommand, int pid) {
        void var1_2;
        Map<Integer, String[]> map;
        Map<Integer, String[]> procList = pid < 0 ? ExecutingCommand.runNative(psCommand) : ExecutingCommand.runNative(psCommand + pid);
        List<String> procList2 = pid < 0 ? ExecutingCommand.runNative("prstat -v 1 1") : ExecutingCommand.runNative("prstat -v -p " + pid + " 1 1");
        map = SolarisOSProcess.parseAndMergePSandPrstatInfo((List<String>)((Object)map), 1, 15, (List<String>)var1_2, false);
        return map.entrySet().stream().map(e -> {
            Map.Entry entry;
            return new SolarisOSProcess((Integer)e.getKey(), (String[])entry.getValue());
        }).collect(Collectors.toList());
    }

    @Override
    public int getProcessId() {
        return SolarisLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcessStat.getPidFiles().length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getThreadCount() {
        List<String> threadList = ExecutingCommand.runNative("ps -eLo pid");
        if (!threadList.isEmpty()) {
            void var1_1;
            return var1_1.size() - 1;
        }
        return this.getProcessCount();
    }

    @Override
    public long getSystemUptime() {
        return SolarisOperatingSystem.querySystemUptime();
    }

    /*
     * WARNING - void declaration
     */
    private static long querySystemUptime() {
        KstatUtil.KstatChain kc = KstatUtil.openChain();
        try {
            LibKstat.Kstat ksp = KstatUtil.KstatChain.lookup("unix", 0, "system_misc");
            if (ksp != null) {
                void var1_1;
                long l = var1_1.ks_snaptime / 1000000000L;
                if (kc != null) {
                    kc.close();
                }
                return l;
            }
            if (kc != null) {
                kc.close();
            }
        }
        catch (Throwable throwable) {
            if (kc != null) {
                try {
                    void var0;
                    var0.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        return 0L;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    /*
     * WARNING - void declaration
     */
    private static long querySystemBootTime() {
        KstatUtil.KstatChain kc = KstatUtil.openChain();
        try {
            LibKstat.Kstat ksp = KstatUtil.KstatChain.lookup("unix", 0, "system_misc");
            if (ksp != null && KstatUtil.KstatChain.read(ksp)) {
                void var1_1;
                long l = KstatUtil.dataLookupLong((LibKstat.Kstat)var1_1, "boot_time");
                if (kc != null) {
                    kc.close();
                }
                return l;
            }
            if (kc != null) {
                kc.close();
            }
        }
        catch (Throwable throwable) {
            if (kc != null) {
                try {
                    void var0;
                    var0.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        return System.currentTimeMillis() / 1000L - SolarisOperatingSystem.querySystemUptime();
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new SolarisNetworkParams();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSService[] getServices() {
        void var1_1;
        File[] listFiles;
        ArrayList<OSService> services = new ArrayList<OSService>();
        ArrayList<String> legacySvcs = new ArrayList<String>();
        File dir = new File("/etc/init.d");
        if (dir.exists() && dir.isDirectory() && (listFiles = dir.listFiles()) != null) {
            void var5_7;
            int n = listFiles.length;
            boolean bl = false;
            while (var5_7 < n) {
                File f = listFiles[var5_7];
                legacySvcs.add(f.getName());
                ++var5_7;
            }
        }
        listFiles = ExecutingCommand.runNative("svcs -p");
        block1: for (String string : listFiles) {
            if (string.startsWith("online")) {
                int delim = string.lastIndexOf(":/");
                if (delim <= 0) continue;
                String name = string.substring(delim + 1);
                if (name.endsWith(":default")) {
                    name = name.substring(0, name.length() - 8);
                }
                services.add(new OSService(name, 0, OSService.State.STOPPED));
                continue;
            }
            if (string.startsWith(" ")) {
                String[] split = ParseUtil.whitespaces.split(string.trim());
                if (split.length != 3) continue;
                services.add(new OSService(split[2], ParseUtil.parseIntOrDefault(split[1], 0), OSService.State.RUNNING));
                continue;
            }
            if (!string.startsWith("legacy_run")) continue;
            for (String svc : legacySvcs) {
                void var3_3;
                if (!string.endsWith(svc)) continue;
                services.add(new OSService((String)var3_3, 0, OSService.State.STOPPED));
                continue block1;
            }
        }
        return var1_1.toArray(new OSService[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryDescendantProcesses$1(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$queryChildProcesses$0(Set descendantPids, OSProcess p) {
        void var1_1;
        return descendantPids.contains(var1_1.getProcessID());
    }
}

