/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsOSSystemInfo {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSSystemInfo.class);
    private WinBase.SYSTEM_INFO systemInfo = null;

    public WindowsOSSystemInfo() {
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public WindowsOSSystemInfo(WinBase.SYSTEM_INFO si) {
        void var1_1;
        this.systemInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var1_1;
        WinBase.SYSTEM_INFO si = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(si);
        try {
            void var3_4;
            IntByReference isWow64 = new IntByReference();
            WinNT.HANDLE hProcess = Kernel32.INSTANCE.GetCurrentProcess();
            if (Kernel32.INSTANCE.IsWow64Process((WinNT.HANDLE)var3_4, isWow64) && isWow64.getValue() > 0) {
                Kernel32.INSTANCE.GetNativeSystemInfo(si);
            }
        }
        catch (UnsatisfiedLinkError e) {
            void var2_3;
            LOG.trace("No WOW64 support: {}", (Object)var2_3.getMessage());
        }
        this.systemInfo = var1_1;
        LOG.debug("Initialized OSNativeSystemInfo");
    }

    public int getNumberOfProcessors() {
        return this.systemInfo.dwNumberOfProcessors.intValue();
    }
}

