/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.registry.ThreadPerformanceData;
import oshi.software.common.AbstractOSThread;
import oshi.software.os.OSProcess;

@ThreadSafe
public class WindowsOSThread
extends AbstractOSThread {
    private final int threadId;
    private String name;
    private OSProcess.State state;
    private long startMemoryAddress;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    /*
     * WARNING - void declaration
     */
    public WindowsOSThread(int pid, int tid, String procName, ThreadPerformanceData.PerfCounterBlock pcb) {
        super((int)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.threadId = var2_2;
        this.updateAttributes((String)var3_3, pcb);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getStartMemoryAddress() {
        return this.startMemoryAddress;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateAttributes() {
        void var2_2;
        Set<Integer> pids = Collections.singleton(this.getOwningProcessId());
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> threads = ThreadPerformanceData.buildThreadMapFromRegistry(pids);
        if (threads == null) {
            void var1_1;
            threads = ThreadPerformanceData.buildThreadMapFromPerfCounters((Collection<Integer>)var1_1);
        }
        WindowsOSThread windowsOSThread = this;
        return windowsOSThread.updateAttributes(windowsOSThread.name.split("/")[0], (ThreadPerformanceData.PerfCounterBlock)var2_2.get(this.getThreadId()));
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateAttributes(String procName, ThreadPerformanceData.PerfCounterBlock pcb) {
        void var2_2;
        void var1_1;
        if (pcb == null) {
            this.state = OSProcess.State.INVALID;
            return false;
        }
        this.name = pcb.getName().contains("/") || procName.isEmpty() ? pcb.getName() : (String)var1_1 + "/" + pcb.getName();
        if (pcb.getThreadWaitReason() == 5) {
            this.state = OSProcess.State.SUSPENDED;
        } else {
            switch (pcb.getThreadState()) {
                case 0: {
                    this.state = OSProcess.State.NEW;
                    break;
                }
                case 2: 
                case 3: {
                    this.state = OSProcess.State.RUNNING;
                    break;
                }
                case 4: {
                    this.state = OSProcess.State.STOPPED;
                    break;
                }
                case 5: {
                    this.state = OSProcess.State.SLEEPING;
                    break;
                }
                case 1: 
                case 6: {
                    this.state = OSProcess.State.WAITING;
                    break;
                }
                default: {
                    this.state = OSProcess.State.OTHER;
                }
            }
        }
        this.startMemoryAddress = pcb.getStartAddress();
        this.contextSwitches = pcb.getContextSwitches();
        this.kernelTime = pcb.getKernelTime();
        this.userTime = pcb.getUserTime();
        this.startTime = pcb.getStartTime();
        this.upTime = System.currentTimeMillis() - pcb.getStartTime();
        this.priority = var2_2.getPriority();
        return true;
    }
}

