/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.PlatformEnum;
import oshi.SystemInfo;
import oshi.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ExecutingCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutingCommand.class);
    private static final String[] DEFAULT_ENV = ExecutingCommand.getDefaultEnv();

    private ExecutingCommand() {
    }

    /*
     * WARNING - void declaration
     */
    private static String[] getDefaultEnv() {
        void var0;
        PlatformEnum platform = SystemInfo.getCurrentPlatform();
        if (platform == PlatformEnum.WINDOWS) {
            return new String[]{"LANGUAGE=C"};
        }
        if (var0 != PlatformEnum.UNKNOWN) {
            return new String[]{"LC_ALL=C"};
        }
        return null;
    }

    public static List<String> runNative(String cmdToRun) {
        String[] stringArray = cmdToRun.split(" ");
        return ExecutingCommand.runNative(stringArray);
    }

    public static List<String> runNative(String[] cmdToRunWithArgs) {
        return ExecutingCommand.runNative(cmdToRunWithArgs, DEFAULT_ENV);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> runNative(String[] cmdToRunWithArgs, String[] envp) {
        void var2_4;
        Process p;
        try {
            p = Runtime.getRuntime().exec(cmdToRunWithArgs, envp);
        }
        catch (IOException | SecurityException e) {
            LOG.trace("Couldn't run command {}: {}", (Object)Arrays.toString(cmdToRunWithArgs), (Object)e.getMessage());
            return new ArrayList<String>(0);
        }
        ArrayList<String> sa = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
            void var1_1;
            String line;
            while ((line = reader.readLine()) != null) {
                sa.add(line);
            }
            var1_1.waitFor();
        }
        catch (IOException e) {
            LOG.trace("Problem reading output from {}: {}", (Object)Arrays.toString(cmdToRunWithArgs), (Object)e.getMessage());
            return new ArrayList<String>(0);
        }
        catch (InterruptedException ie) {
            void var3_7;
            String[] stringArray;
            LOG.trace("Interrupted while reading output from {}: {}", (Object)Arrays.toString(stringArray), (Object)var3_7.getMessage());
            Thread.currentThread().interrupt();
        }
        return var2_4;
    }

    public static String getFirstAnswer(String cmd2launch) {
        return ExecutingCommand.getAnswerAt(cmd2launch, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String getAnswerAt(String cmd2launch, int answerIdx) {
        List<String> sa = ExecutingCommand.runNative(cmd2launch);
        if (answerIdx >= 0 && answerIdx < sa.size()) {
            void var1_1;
            List<String> list;
            return (String)list.get((int)var1_1);
        }
        return "";
    }
}

