/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ParseUtil;

@ThreadSafe
public final class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static final String READING_LOG = "Reading file {}";
    private static final String READ_LOG = "Read {}";

    private FileUtil() {
    }

    public static List<String> readFile(String filename) {
        return FileUtil.readFile(filename, true);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readFile(String filename, boolean reportError) {
        void var1_1;
        if (new File(filename).canRead()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(READING_LOG, (Object)filename);
            }
            try {
                return Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                if (reportError) {
                    LOG.error("Error reading file {}. {}", (Object)filename, (Object)e.getMessage());
                } else {
                    void var2_2;
                    LOG.debug("Error reading file {}. {}", (Object)filename, (Object)var2_2.getMessage());
                }
            }
        } else if (var1_1 != false) {
            String string;
            LOG.warn("File not found or not readable: {}", (Object)string);
        }
        return new ArrayList<String>();
    }

    public static long getLongFromFile(String filename) {
        Object read;
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_LOG, (Object)filename);
        }
        if (!(read = FileUtil.readFile(filename, false)).isEmpty()) {
            Object object;
            if (LOG.isTraceEnabled()) {
                LOG.trace(READ_LOG, read.get(0));
            }
            return ParseUtil.parseLongOrDefault((String)object.get(0), 0L);
        }
        return 0L;
    }

    public static long getUnsignedLongFromFile(String filename) {
        Object read;
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_LOG, (Object)filename);
        }
        if (!(read = FileUtil.readFile(filename, false)).isEmpty()) {
            Object object;
            if (LOG.isTraceEnabled()) {
                LOG.trace(READ_LOG, read.get(0));
            }
            return ParseUtil.parseUnsignedLongOrDefault((String)object.get(0), 0L);
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public static int getIntFromFile(String filename) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_LOG, (Object)filename);
        }
        try {
            List<String> read = FileUtil.readFile(filename, false);
            if (!read.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(READ_LOG, (Object)read.get(0));
                }
                return Integer.parseInt(read.get(0));
            }
        }
        catch (NumberFormatException ex) {
            void var1_2;
            String string;
            LOG.warn("Unable to read value from {}. {}", (Object)string, (Object)var1_2.getMessage());
        }
        return 0;
    }

    public static String getStringFromFile(String filename) {
        Object read;
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_LOG, (Object)filename);
        }
        if (!(read = FileUtil.readFile(filename, false)).isEmpty()) {
            Object object;
            if (LOG.isTraceEnabled()) {
                LOG.trace(READ_LOG, read.get(0));
            }
            return (String)object.get(0);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> getKeyValueMapFromFile(String filename, String separator) {
        void var2_2;
        Iterator<String> iterator;
        HashMap<String, String> map = new HashMap<String, String>();
        if (LOG.isDebugEnabled()) {
            LOG.debug(READING_LOG, (Object)filename);
        }
        iterator = FileUtil.readFile((String)((Object)iterator), false);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String[] parts = string.split(separator);
            if (parts.length != 2) continue;
            map.put(parts[0], string[1].trim());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Properties readPropertiesFromFilename(String propsFilename) {
        void var1_1;
        String string;
        Properties archProps = new Properties();
        if (FileUtil.readPropertiesFromClassLoader(propsFilename, archProps, Thread.currentThread().getContextClassLoader()) || FileUtil.readPropertiesFromClassLoader(propsFilename, archProps, ClassLoader.getSystemClassLoader()) || FileUtil.readPropertiesFromClassLoader(string, archProps, FileUtil.class.getClassLoader())) {
            return archProps;
        }
        LOG.warn("Failed to load default configuration");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean readPropertiesFromClassLoader(String propsFilename, Properties archProps, ClassLoader loader) {
        if (loader == null) {
            return false;
        }
        try {
            void var3_5;
            ArrayList<URL> resources = Collections.list(loader.getResources(propsFilename));
            if (resources.isEmpty()) {
                void var2_4;
                LOG.info("No {} file found from ClassLoader {}", (Object)propsFilename, (Object)var2_4);
                return false;
            }
            if (resources.size() > 1) {
                LOG.warn("Configuration conflict: there is more than one {} file on the classpath", (Object)propsFilename);
                return true;
            }
            InputStream in = ((URL)var3_5.get(0)).openStream();
            try {
                if (in != null) {
                    void var1_2;
                    var1_2.load(in);
                }
                if (in == null) return true;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    InputStream inputStream;
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            in.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String readSymlinkTarget(File file) {
        try {
            return Files.readSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0])).toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

