/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class LsofUtil {
    private LsofUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Integer, String> getCwdMap(int pid) {
        void var1_2;
        Iterator iterator;
        List<String> lsof = ExecutingCommand.runNative("lsof -F n -d cwd" + (pid < 0 ? "" : " -p " + pid));
        HashMap<Integer, String> cwdMap = new HashMap<Integer, String>();
        Integer key = -1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (line.isEmpty()) continue;
            switch (line.charAt(0)) {
                case 'p': {
                    key = ParseUtil.parseIntOrDefault(line.substring(1), -1);
                    break;
                }
                case 'n': {
                    void var3_4;
                    cwdMap.put(key, var3_4.substring(1));
                }
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String getCwd(int pid) {
        int n;
        Object object = ExecutingCommand.runNative("lsof -F n -d cwd -p " + n);
        object = object.iterator();
        while (object.hasNext()) {
            void var1_2;
            String line = (String)object.next();
            if (line.isEmpty() || line.charAt(0) != 'n') continue;
            return var1_2.substring(1).trim();
        }
        return "";
    }

    public static long getOpenFiles(int pid) {
        int openFiles = ExecutingCommand.runNative("lsof -p " + pid).size();
        if (openFiles > 0) {
            int n;
            return (long)n - 1L;
        }
        return 0L;
    }
}

