/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.GlobalConfig;

@ThreadSafe
public final class Memoizer {
    private static final Supplier<Long> defaultExpirationNanos = Memoizer.memoize(Memoizer::queryExpirationConfig, TimeUnit.MINUTES.toNanos(1L));

    private Memoizer() {
    }

    private static long queryExpirationConfig() {
        return TimeUnit.MILLISECONDS.toNanos(GlobalConfig.get("oshi.util.memoizer.expiration", 300));
    }

    public static long defaultExpiration() {
        return defaultExpirationNanos.get();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Supplier<T> memoize(Supplier<T> original, long ttlNanos) {
        void var1_1;
        Supplier<T> supplier;
        return new Supplier<T>(){
            final Supplier<T> delegate;
            volatile T value;
            volatile long expirationNanos;
            final /* synthetic */ long val$ttlNanos;
            {
                this.val$ttlNanos = l;
                this.delegate = supplier;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public T get() {
                long nanos = this.expirationNanos;
                long now = System.nanoTime();
                if (nanos == 0L || this.val$ttlNanos >= 0L && now - nanos >= 0L) {
                    1 var5_4 = this;
                    synchronized (var5_4) {
                        if (nanos == this.expirationNanos) {
                            void var1_1;
                            void var3_3;
                            Object t = this.delegate.get();
                            this.value = t;
                            nanos = var3_3 + this.val$ttlNanos;
                            this.expirationNanos = nanos == 0L ? 1L : var1_1;
                            return t;
                        }
                    }
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> memoize(Supplier<T> original) {
        return Memoizer.memoize(original, -1L);
    }
}

