/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.freebsd.FreeBsdLibc;

@ThreadSafe
public final class BsdSysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BsdSysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed syctl call: {}, Error code: {}";

    private BsdSysctlUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static int sysctl(String name, int def) {
        void var3_3;
        void var2_2;
        IntByReference size = new IntByReference(FreeBsdLibc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, (IntByReference)var2_2, null, 0)) {
            void var1_1;
            String string;
            LOG.error("Failed sysctl call: {}, Error code: {}", (Object)string, (Object)Native.getLastError());
            return (int)var1_1;
        }
        return var3_3.getInt(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static long sysctl(String name, long def) {
        void var3_2;
        IntByReference size = new IntByReference(FreeBsdLibc.UINT64_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, (IntByReference)var3_2, null, 0)) {
            void var1_1;
            String string;
            LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return (long)var1_1;
        }
        return p.getLong(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static String sysctl(String name, String def) {
        void var3_3;
        void var2_2;
        IntByReference size = new IntByReference();
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, null, size, null, 0)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        Memory p = new Memory((long)size.getValue() + 1L);
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, (IntByReference)var2_2, null, 0)) {
            void var1_1;
            String string;
            LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return var1_1;
        }
        return var3_3.getString(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sysctl(String name, Structure struct) {
        void var1_1;
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, struct.getPointer(), new IntByReference(struct.size()), null, 0)) {
            String string;
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return false;
        }
        var1_1.read();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static Memory sysctl(String name) {
        void var2_2;
        void var1_1;
        IntByReference size = new IntByReference();
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, null, size, null, 0)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        Memory m = new Memory((long)size.getValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)m, (IntByReference)var1_1, null, 0)) {
            String string;
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return null;
        }
        return var2_2;
    }
}

