/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.solaris;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FormatUtil;
import oshi.util.Util;

@ThreadSafe
public final class KstatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KstatUtil.class);
    private static final LibKstat KS = LibKstat.INSTANCE;
    private static final LibKstat.KstatCtl KC = KS.kstat_open();
    private static final ReentrantLock CHAIN = new ReentrantLock();

    private KstatUtil() {
    }

    public static KstatChain openChain() {
        return new KstatChain();
    }

    /*
     * WARNING - void declaration
     */
    public static String dataLookupString(LibKstat.Kstat ksp, String name) {
        LibKstat.Kstat kstat;
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        LibKstat.Kstat p = KS.kstat_data_lookup(ksp, name);
        if (p == null) {
            void var1_1;
            LOG.debug("Failed to lookup kstat value for key {}", (Object)var1_1);
            return "";
        }
        LibKstat.Kstat data = new LibKstat.KstatNamed((Pointer)p);
        switch (data.data_type) {
            case 0: {
                return Native.toString((byte[])data.value.charc, (Charset)StandardCharsets.UTF_8);
            }
            case 1: {
                return Integer.toString(data.value.i32);
            }
            case 2: {
                return FormatUtil.toUnsignedString(data.value.ui32);
            }
            case 3: {
                return Long.toString(data.value.i64);
            }
            case 4: {
                return FormatUtil.toUnsignedString(data.value.ui64);
            }
            case 9: {
                return data.value.str.addr.getString(0L);
            }
        }
        LOG.error("Unimplemented kstat data type {}", (Object)kstat.data_type);
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static long dataLookupLong(LibKstat.Kstat ksp, String name) {
        LibKstat.Kstat kstat;
        void var2_2;
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = KS.kstat_data_lookup(ksp, name);
        if (p == null) {
            if (LOG.isErrorEnabled()) {
                void var1_1;
                LOG.error("Failed lo lookup kstat value on {}:{}:{} for key {}", new Object[]{Native.toString((byte[])ksp.ks_module, (Charset)StandardCharsets.US_ASCII), ksp.ks_instance, Native.toString((byte[])ksp.ks_name, (Charset)StandardCharsets.US_ASCII), var1_1});
            }
            return 0L;
        }
        LibKstat.Kstat data = new LibKstat.KstatNamed((Pointer)var2_2);
        switch (data.data_type) {
            case 1: {
                return data.value.i32;
            }
            case 2: {
                return FormatUtil.getUnsignedInt(data.value.ui32);
            }
            case 3: {
                return data.value.i64;
            }
            case 4: {
                return data.value.ui64;
            }
        }
        LOG.error("Unimplemented or non-numeric kstat data type {}", (Object)kstat.data_type);
        return 0L;
    }

    public static final class KstatChain
    implements AutoCloseable {
        private KstatChain() {
            CHAIN.lock();
            KstatChain.update();
        }

        public static boolean read(LibKstat.Kstat ksp) {
            int retry = 0;
            while (0 > KS.kstat_read(KC, ksp, null)) {
                if (11 != Native.getLastError() || 5 <= ++retry) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to read kstat {}:{}:{}", new Object[]{Native.toString((byte[])ksp.ks_module, (Charset)StandardCharsets.US_ASCII), ksp.ks_instance, Native.toString((byte[])ksp.ks_name, (Charset)StandardCharsets.US_ASCII)});
                    }
                    return false;
                }
                Util.sleep(8 << retry);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public static LibKstat.Kstat lookup(String module, int instance, String name) {
            void var2_2;
            void var1_1;
            String string;
            return KS.kstat_lookup(KC, string, (int)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static List<LibKstat.Kstat> lookupAll(String module, int instance, String name) {
            void var3_3;
            ArrayList<LibKstat.Kstat> kstats = new ArrayList<LibKstat.Kstat>();
            for (LibKstat.Kstat ksp = KS.kstat_lookup(KC, module, instance, name); ksp != null; ksp = ksp.next()) {
                if (module != null && !module.equals(Native.toString((byte[])ksp.ks_module, (Charset)StandardCharsets.US_ASCII)) || instance >= 0 && instance != ksp.ks_instance || name != null && !name.equals(Native.toString((byte[])ksp.ks_name, (Charset)StandardCharsets.US_ASCII))) continue;
                kstats.add(ksp);
            }
            return var3_3;
        }

        public static int update() {
            return KS.kstat_chain_update(KC);
        }

        @Override
        public final void close() {
            CHAIN.unlock();
        }
    }
}

