/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.PdhUtil;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.GuardedBy;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.platform.windows.PerfCounterQueryHandler;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
public final class PerfCounterQuery {
    private static final Logger LOG = LoggerFactory.getLogger(PerfCounterQuery.class);
    @GuardedBy(value="failedQueryCacheLock")
    private static final Set<String> failedQueryCache = new HashSet<String>();
    private static final ReentrantLock failedQueryCacheLock = new ReentrantLock();
    private static final ConcurrentHashMap<String, String> localizeCache = new ConcurrentHashMap();
    public static final String TOTAL_INSTANCE = "_Total";
    public static final String TOTAL_INSTANCES = "*_Total";
    public static final String NOT_TOTAL_INSTANCE = "^_Total";
    public static final String NOT_TOTAL_INSTANCES = "^*_Total";

    private PerfCounterQuery() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> Map<T, Long> queryValues(Class<T> propertyEnum, String perfObject, String perfWmiClass) {
        void var2_3;
        Class<T> clazz;
        if (!failedQueryCache.contains(perfObject)) {
            failedQueryCacheLock.lock();
            try {
                if (!failedQueryCache.contains(perfObject)) {
                    void var1_2;
                    Map<T, Long> valueMap = PerfCounterQuery.queryValuesFromPDH(propertyEnum, perfObject);
                    if (!valueMap.isEmpty()) {
                        void var3_4;
                        propertyEnum = var3_4;
                        return propertyEnum;
                    }
                    LOG.warn("Disabling further attempts to query {}.", (Object)perfObject);
                    failedQueryCache.add((String)var1_2);
                }
            }
            finally {
                failedQueryCacheLock.unlock();
            }
        }
        return PerfCounterQuery.queryValuesFromWMI(clazz, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> Map<T, Long> queryValuesFromPDH(Class<T> propertyEnum, String perfObject) {
        Serializable serializable;
        Enum[] props = (Enum[])propertyEnum.getEnumConstants();
        String perfObjectLocalized = PerfCounterQuery.localize(perfObject);
        EnumMap<T, PerfDataUtil.PerfCounter> counterMap = new EnumMap<T, PerfDataUtil.PerfCounter>(propertyEnum);
        Serializable valueMap = new EnumMap(propertyEnum);
        try (PerfCounterQueryHandler pdhQueryHandler = new PerfCounterQueryHandler();){
            Enum[] enumArray = props;
            int n = props.length;
            for (int i = 0; i < n; ++i) {
                Enum prop = enumArray[i];
                PerfDataUtil.PerfCounter counter = PerfDataUtil.createCounter(perfObjectLocalized, ((PdhCounterProperty)((Object)prop)).getInstance(), ((PdhCounterProperty)((Object)prop)).getCounter());
                counterMap.put(prop, counter);
                if (pdhQueryHandler.addCounterToQuery(counter)) continue;
                return valueMap;
            }
            if (0L < pdhQueryHandler.updateQuery()) {
                void var2_2;
                for (Enum prop : var2_2) {
                    ((EnumMap)valueMap).put(prop, pdhQueryHandler.queryCounter((PerfDataUtil.PerfCounter)counterMap.get(prop)));
                }
            }
        }
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> Map<T, Long> queryValuesFromWMI(Class<T> propertyEnum, String wmiClass) {
        void var2_2;
        WbemcliUtil.WmiQuery query = new WbemcliUtil.WmiQuery(wmiClass, propertyEnum);
        WbemcliUtil.WmiResult result = WmiQueryHandler.createInstance().queryWMI(query);
        EnumMap<T, Long> valueMap = new EnumMap<T, Long>(propertyEnum);
        if (result.getResultCount() > 0) {
            Enum[] enumArray;
            block6: for (Enum prop : (Enum[])enumArray.getEnumConstants()) {
                switch (result.getCIMType(prop)) {
                    case 18: {
                        valueMap.put(prop, Long.valueOf(WmiUtil.getUint16(result, prop, 0)));
                        continue block6;
                    }
                    case 19: {
                        valueMap.put(prop, WmiUtil.getUint32asLong(result, prop, 0));
                        continue block6;
                    }
                    case 21: {
                        valueMap.put(prop, WmiUtil.getUint64(result, prop, 0));
                        continue block6;
                    }
                    case 101: {
                        valueMap.put(prop, WmiUtil.getDateTime(result, prop, 0).toInstant().toEpochMilli());
                        continue block6;
                    }
                    default: {
                        throw new ClassCastException("Unimplemented CIM Type Mapping.");
                    }
                }
            }
        }
        return var2_2;
    }

    public static String localize(String perfObject) {
        String string;
        return localizeCache.computeIfAbsent(string, k -> PerfCounterQuery.localizeUsingPerfIndex(k));
    }

    /*
     * WARNING - void declaration
     */
    private static String localizeUsingPerfIndex(String perfObject) {
        void var1_1;
        String string;
        String localized = perfObject;
        try {
            localized = PdhUtil.PdhLookupPerfNameByIndex(null, (int)PdhUtil.PdhLookupPerfIndexByEnglishName((String)perfObject));
        }
        catch (Win32Exception e) {
            LOG.warn("Unable to locate English counter names in registry Perflib 009. Assuming English counters. Error {}. {}", (Object)String.format("0x%x", e.getHR().intValue()), (Object)"See https://support.microsoft.com/en-us/help/300956/how-to-manually-rebuild-performance-counter-library-values");
        }
        catch (PdhUtil.PdhException e) {
            void var2_3;
            LOG.warn("Unable to localize {} performance counter.  Error {}.", (Object)perfObject, (Object)String.format("0x%x", var2_3.getErrorCode()));
        }
        if (localized.isEmpty()) {
            return perfObject;
        }
        LOG.debug("Localized {} to {}", (Object)string, (Object)localized);
        return var1_1;
    }

    public static interface PdhCounterProperty {
        public String getInstance();

        public String getCounter();
    }
}

