/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.PdhUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.GuardedBy;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.Util;
import oshi.util.platform.windows.PerfCounterQuery;
import oshi.util.platform.windows.PerfCounterQueryHandler;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public final class PerfCounterWildcardQuery {
    private static final Logger LOG = LoggerFactory.getLogger(PerfCounterWildcardQuery.class);
    @GuardedBy(value="failedQueryCacheLock")
    private static final Set<String> failedQueryCache = new HashSet<String>();
    private static final ReentrantLock failedQueryCacheLock = new ReentrantLock();

    private PerfCounterWildcardQuery() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> Pair<List<String>, Map<T, List<Long>>> queryInstancesAndValues(Class<T> propertyEnum, String perfObject, String perfWmiClass) {
        void var2_3;
        Class<T> clazz;
        if (!failedQueryCache.contains(perfObject)) {
            failedQueryCacheLock.lock();
            try {
                if (!failedQueryCache.contains(perfObject)) {
                    void var1_2;
                    Pair<List<String>, Map<T, List<Long>>> instancesAndValuesMap = PerfCounterWildcardQuery.queryInstancesAndValuesFromPDH(propertyEnum, perfObject);
                    if (!instancesAndValuesMap.getA().isEmpty()) {
                        void var3_4;
                        propertyEnum = var3_4;
                        return propertyEnum;
                    }
                    LOG.warn("Disabling further attempts to query {}.", (Object)perfObject);
                    failedQueryCache.add((String)var1_2);
                }
            }
            finally {
                failedQueryCacheLock.unlock();
            }
        }
        return PerfCounterWildcardQuery.queryInstancesAndValuesFromWMI(clazz, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> Pair<List<String>, Map<T, List<Long>>> queryInstancesAndValuesFromPDH(Class<T> propertyEnum, String perfObject) {
        void var3_4;
        PdhUtil.PdhEnumObjectItems objectItems;
        Enum[] props = (Enum[])propertyEnum.getEnumConstants();
        if (props.length < 2) {
            throw new IllegalArgumentException("Enum " + propertyEnum.getName() + " must have at least two elements, an instance filter and a counter.");
        }
        String instanceFilter = ((PdhCounterWildcardProperty)((Object)((Enum[])propertyEnum.getEnumConstants())[0])).getCounter().toLowerCase();
        String perfObjectLocalized = PerfCounterQuery.localize(perfObject);
        try {
            objectItems = PdhUtil.PdhEnumObjectItems(null, null, (String)perfObjectLocalized, (int)100);
        }
        catch (PdhUtil.PdhException pdhException) {
            return new Pair<List<String>, Map<T, List<Long>>>(Collections.emptyList(), Collections.emptyMap());
        }
        List instances = objectItems.getInstances();
        instances.removeIf(i -> {
            String string;
            return !Util.wildcardMatch(i.toLowerCase(), string);
        });
        EnumMap valuesMap = new EnumMap(propertyEnum);
        try (PerfCounterQueryHandler pdhQueryHandler = new PerfCounterQueryHandler();){
            Enum prop;
            int i2;
            Object counterListMap = new EnumMap(propertyEnum);
            for (i2 = 1; i2 < props.length; ++i2) {
                prop = props[i2];
                ArrayList<PerfDataUtil.PerfCounter> counterList = new ArrayList<PerfDataUtil.PerfCounter>(instances.size());
                for (String instance : instances) {
                    PerfDataUtil.PerfCounter counter = PerfDataUtil.createCounter(perfObject, instance, ((PdhCounterWildcardProperty)((Object)prop)).getCounter());
                    if (!pdhQueryHandler.addCounterToQuery(counter)) {
                        counterListMap = new Pair(Collections.emptyList(), Collections.emptyMap());
                        return counterListMap;
                    }
                    counterList.add(counter);
                }
                ((EnumMap)counterListMap).put(prop, counterList);
            }
            if (0L < pdhQueryHandler.updateQuery()) {
                for (i2 = 1; i2 < props.length; ++i2) {
                    prop = props[i2];
                    ArrayList<Long> values = new ArrayList<Long>();
                    for (PerfDataUtil.PerfCounter counter : (List)((EnumMap)counterListMap).get(prop)) {
                        values.add(pdhQueryHandler.queryCounter(counter));
                    }
                    valuesMap.put(prop, values);
                }
            }
        }
        return new Pair<List, void>(instances, var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> Pair<List<String>, Map<T, List<Long>>> queryInstancesAndValuesFromWMI(Class<T> propertyEnum, String wmiClass) {
        void var3_3;
        void var2_2;
        ArrayList<String> instances = new ArrayList<String>();
        EnumMap valuesMap = new EnumMap(propertyEnum);
        WbemcliUtil.WmiQuery query = new WbemcliUtil.WmiQuery(wmiClass, propertyEnum);
        WbemcliUtil.WmiResult result = WmiQueryHandler.createInstance().queryWMI(query);
        if (result.getResultCount() > 0) {
            Enum[] enumArray;
            for (Enum prop : (Enum[])enumArray.getEnumConstants()) {
                if (prop.ordinal() == 0) {
                    for (int i = 0; i < result.getResultCount(); ++i) {
                        instances.add(WmiUtil.getString(result, prop, i));
                    }
                    continue;
                }
                ArrayList<Long> values = new ArrayList<Long>();
                block8: for (int i = 0; i < result.getResultCount(); ++i) {
                    switch (result.getCIMType(prop)) {
                        case 18: {
                            values.add(Long.valueOf(WmiUtil.getUint16(result, prop, i)));
                            continue block8;
                        }
                        case 19: {
                            values.add(WmiUtil.getUint32asLong(result, prop, i));
                            continue block8;
                        }
                        case 21: {
                            values.add(WmiUtil.getUint64(result, prop, i));
                            continue block8;
                        }
                        case 101: {
                            values.add(WmiUtil.getDateTime(result, prop, i).toInstant().toEpochMilli());
                            continue block8;
                        }
                        default: {
                            throw new ClassCastException("Unimplemented CIM Type Mapping.");
                        }
                    }
                }
                valuesMap.put(prop, values);
            }
        }
        return new Pair<void, void>(var2_2, var3_3);
    }

    public static interface PdhCounterWildcardProperty {
        public String getCounter();
    }
}

