/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Pdh;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;
import oshi.util.Util;

@ThreadSafe
public final class PerfDataUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PerfDataUtil.class);
    private static final BaseTSD.DWORD_PTR PZERO = new BaseTSD.DWORD_PTR(0L);
    private static final WinDef.DWORDByReference PDH_FMT_RAW = new WinDef.DWORDByReference(new WinDef.DWORD(16L));
    private static final Pdh PDH = Pdh.INSTANCE;
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();

    private PerfDataUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static PerfCounter createCounter(String object, String instance, String counter) {
        void var2_2;
        void var1_1;
        String string;
        return new PerfCounter(string, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long updateQueryTimestamp(WinNT.HANDLEByReference query) {
        WinDef.LONGLONGByReference pllTimeStamp = new WinDef.LONGLONGByReference();
        int ret = IS_VISTA_OR_GREATER ? PDH.PdhCollectQueryDataWithTime(query.getValue(), pllTimeStamp) : PDH.PdhCollectQueryData(query.getValue());
        int retries = 0;
        while (ret == -2147481643 && retries++ < 3) {
            Util.sleep(1 << retries);
            ret = IS_VISTA_OR_GREATER ? PDH.PdhCollectQueryDataWithTime(query.getValue(), pllTimeStamp) : PDH.PdhCollectQueryData(query.getValue());
        }
        if (ret != 0) {
            if (LOG.isWarnEnabled()) {
                void var2_2;
                LOG.warn("Failed to update counter. Error code: {}", (Object)String.format(FormatUtil.formatError((int)var2_2), new Object[0]));
            }
            return 0L;
        }
        if (IS_VISTA_OR_GREATER) {
            void var1_1;
            return ParseUtil.filetimeToUtcMs(var1_1.getValue().longValue(), true);
        }
        return System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean openQuery(WinNT.HANDLEByReference q) {
        int ret = PDH.PdhOpenQuery(null, PZERO, q);
        if (ret != 0) {
            if (LOG.isErrorEnabled()) {
                void var0_1;
                LOG.error("Failed to open PDH Query. Error code: {}", (Object)String.format(FormatUtil.formatError((int)var0_1), new Object[0]));
            }
            return false;
        }
        return true;
    }

    public static boolean closeQuery(WinNT.HANDLEByReference q) {
        WinNT.HANDLEByReference hANDLEByReference;
        return 0 == PDH.PdhCloseQuery(hANDLEByReference.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static long queryCounter(WinNT.HANDLEByReference counter) {
        void var1_2;
        Pdh.PDH_RAW_COUNTER counterValue = new Pdh.PDH_RAW_COUNTER();
        int ret = PDH.PdhGetRawCounterValue(counter.getValue(), PDH_FMT_RAW, counterValue);
        if (ret != 0) {
            void var0_1;
            if (LOG.isWarnEnabled()) {
                LOG.warn("Failed to get counter. Error code: {}", (Object)String.format(FormatUtil.formatError(ret), new Object[0]));
            }
            return (long)var0_1;
        }
        return var1_2.FirstValue;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addCounter(WinNT.HANDLEByReference query, String path, WinNT.HANDLEByReference p) {
        void var2_3;
        int ret = IS_VISTA_OR_GREATER ? PDH.PdhAddEnglishCounter(query.getValue(), path, PZERO, p) : PDH.PdhAddCounter(query.getValue(), path, PZERO, (WinNT.HANDLEByReference)var2_3);
        if (ret != 0) {
            if (LOG.isWarnEnabled()) {
                void var0_1;
                void var1_2;
                LOG.warn("Failed to add PDH Counter: {}, Error code: {}", (Object)var1_2, (Object)String.format(FormatUtil.formatError((int)var0_1), new Object[0]));
            }
            return false;
        }
        return true;
    }

    public static boolean removeCounter(WinNT.HANDLEByReference p) {
        WinNT.HANDLEByReference hANDLEByReference;
        return 0 == PDH.PdhRemoveCounter(hANDLEByReference.getValue());
    }

    @Immutable
    public static class PerfCounter {
        private String object;
        private String instance;
        private String counter;

        /*
         * WARNING - void declaration
         */
        public PerfCounter(String objectName, String instanceName, String counterName) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.object = var1_1;
            this.instance = var2_2;
            this.counter = var3_3;
        }

        public String getObject() {
            return this.object;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getCounter() {
            return this.counter;
        }

        /*
         * WARNING - void declaration
         */
        public String getCounterPath() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append('\\').append(this.object);
            if (this.instance != null) {
                sb.append('(').append(this.instance).append(')');
            }
            sb.append('\\').append(this.counter);
            return var1_1.toString();
        }
    }
}

