/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.time.OffsetDateTime;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.Constants;
import oshi.util.ParseUtil;

@ThreadSafe
public final class WmiUtil {
    public static final String OHM_NAMESPACE = "ROOT\\OpenHardwareMonitor";
    private static final String CLASS_CAST_MSG = "%s is not a %s type. CIM Type is %d and VT type is %d";

    private WmiUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> String queryToString(WbemcliUtil.WmiQuery<T> query) {
        void var2_2;
        WbemcliUtil.WmiQuery<T> wmiQuery;
        Enum[] props = (Enum[])query.getPropertyEnum().getEnumConstants();
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(props[0].name());
        for (int i = 1; i < props.length; ++i) {
            sb.append(',').append(props[i].name());
        }
        sb.append(" FROM ").append(wmiQuery.getWmiClassName());
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> String getString(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        if (result.getCIMType(property) == 8) {
            void var2_2;
            return WmiUtil.getStr(result, property, (int)var2_2);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "String", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> String getDateString(WbemcliUtil.WmiResult<T> result, T property, int index) {
        OffsetDateTime offsetDateTime;
        void var2_2;
        void var1_1;
        OffsetDateTime dateTime = WmiUtil.getDateTime(result, var1_1, (int)var2_2);
        if (dateTime.equals(Constants.UNIX_EPOCH)) {
            return "";
        }
        return offsetDateTime.toLocalDate().toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> OffsetDateTime getDateTime(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        if (result.getCIMType(property) == 101) {
            void var2_2;
            return ParseUtil.parseCimDateTimeToOffset(WmiUtil.getStr(result, property, (int)var2_2));
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "DateTime", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> String getRefString(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        if (result.getCIMType(property) == 102) {
            void var2_2;
            return WmiUtil.getStr(result, property, (int)var2_2);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "Reference", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Enum<T>> String getStr(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        Object o = result.getValue(property, index);
        if (o == null) {
            return "";
        }
        if (result.getVtType(property) == 8) {
            void var2_3;
            return (String)var2_3;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "String-mapped", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> long getUint64(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        Object o = result.getValue(property, index);
        if (o == null) {
            return 0L;
        }
        if (result.getCIMType(property) == 21 && result.getVtType(property) == 8) {
            void var2_3;
            return ParseUtil.parseLongOrDefault((String)var2_3, 0L);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT64", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> int getUint32(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        if (result.getCIMType(property) == 19) {
            void var2_2;
            return WmiUtil.getInt(result, property, (int)var2_2);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT32", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> long getUint32asLong(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        if (result.getCIMType(property) == 19) {
            void var2_2;
            return (long)WmiUtil.getInt(result, property, (int)var2_2) & 0xFFFFFFFFL;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT32", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> int getSint32(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        if (result.getCIMType(property) == 3) {
            void var2_2;
            return WmiUtil.getInt(result, property, (int)var2_2);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "SINT32", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> int getUint16(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        if (result.getCIMType(property) == 18) {
            void var2_2;
            return WmiUtil.getInt(result, property, (int)var2_2);
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "UINT16", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Enum<T>> int getInt(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        Object o = result.getValue(property, index);
        if (o == null) {
            return 0;
        }
        if (result.getVtType(property) == 3) {
            void var2_3;
            return (Integer)var2_3;
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "32-bit integer", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Enum<T>> float getFloat(WbemcliUtil.WmiResult<T> result, T property, int index) {
        void var1_1;
        WbemcliUtil.WmiResult<T> wmiResult;
        Object o = result.getValue(property, index);
        if (o == null) {
            return 0.0f;
        }
        if (result.getCIMType(property) == 4 && result.getVtType(property) == 4) {
            void var2_3;
            return ((Float)var2_3).floatValue();
        }
        throw new ClassCastException(String.format(CLASS_CAST_MSG, property.name(), "Float", result.getCIMType(property), wmiResult.getVtType((Enum)var1_1)));
    }
}

