/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuationImplKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.channels.AbstractChannel;
import kotlinx.coroutines.channels.AbstractChannelKt;
import kotlinx.coroutines.channels.AbstractSendChannel;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Closed;
import kotlinx.coroutines.channels.Receive;
import kotlinx.coroutines.channels.ReceiveOrClosed;
import kotlinx.coroutines.channels.Send;
import kotlinx.coroutines.internal.AtomicKt;
import kotlinx.coroutines.internal.OnUndeliveredElementKt;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.internal.UndeliveredElementException;
import kotlinx.coroutines.selects.SelectInstance;
import kotlinx.coroutines.selects.SelectKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000BB9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012 \u0010\t\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00172\u0006\u0010\r\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ#\u0010 \u001a\u00020\u00172\u0006\u0010\r\u001a\u00028\u00002\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b#\u0010$J\u0011\u0010%\u001a\u0004\u0018\u00010\u0017H\u0014\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010'\u001a\u0004\u0018\u00010\u00172\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014\u00a2\u0006\u0004\b'\u0010(J\u0019\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b*\u0010+R\u001e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00102\u001a\u00020/8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00103R\u0016\u00104\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00103R\u0014\u00105\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00106R\u0014\u00108\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00106R\u0014\u00109\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00106R\u0014\u0010:\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00106R\u0014\u0010;\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00106R\u0018\u0010>\u001a\u00060<j\u0002`=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010@\u00a8\u0006A"}, d2={"Lkotlinx/coroutines/channels/ArrayChannel;", "E", "", "capacity", "Lkotlinx/coroutines/channels/BufferOverflow;", "onBufferOverflow", "Lkotlin/Function1;", "", "Lkotlinx/coroutines/internal/OnUndeliveredElement;", "onUndeliveredElement", "<init>", "(ILkotlinx/coroutines/channels/BufferOverflow;Lkotlin/jvm/functions/Function1;)V", "currentSize", "element", "enqueueElement", "(ILjava/lang/Object;)V", "Lkotlinx/coroutines/channels/Receive;", "receive", "", "enqueueReceiveInternal", "(Lkotlinx/coroutines/channels/Receive;)Z", "Lkotlinx/coroutines/channels/Send;", "send", "", "enqueueSend", "(Lkotlinx/coroutines/channels/Send;)Ljava/lang/Object;", "ensureCapacity", "(I)V", "offerInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", "Lkotlinx/coroutines/selects/SelectInstance;", "select", "offerSelectInternal", "(Ljava/lang/Object;Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "wasClosed", "onCancelIdempotent", "(Z)V", "pollInternal", "()Ljava/lang/Object;", "pollSelectInternal", "(Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "Lkotlinx/coroutines/internal/Symbol;", "updateBufferSize", "(I)Lkotlinx/coroutines/internal/Symbol;", "", "buffer", "[Ljava/lang/Object;", "", "getBufferDebugString", "()Ljava/lang/String;", "bufferDebugString", "I", "head", "isBufferAlwaysEmpty", "()Z", "isBufferAlwaysFull", "isBufferEmpty", "isBufferFull", "isClosedForReceive", "isEmpty", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/internal/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/channels/BufferOverflow;", "kotlinx-coroutines-core", "Lkotlinx/coroutines/channels/AbstractChannel;"})
public class ArrayChannel<E>
extends AbstractChannel<E> {
    private final int capacity;
    private final BufferOverflow onBufferOverflow;
    private final ReentrantLock lock;
    private Object[] buffer;
    private int head;
    private volatile /* synthetic */ int size;

    /*
     * WARNING - void declaration
     */
    public ArrayChannel(int capacity, BufferOverflow onBufferOverflow, Function1<? super E, Unit> onUndeliveredElement) {
        super(arrayChannel);
        void var2_3;
        Object[] objectArray;
        void var1_1;
        ArrayChannel arrayChannel;
        this.capacity = var1_1;
        this.onBufferOverflow = onBufferOverflow;
        if (!(this.capacity > 0)) {
            onBufferOverflow = "ArrayChannel capacity must be at least 1, but " + this.capacity + " was specified";
            throw new IllegalArgumentException(onBufferOverflow.toString());
        }
        this.lock = new ReentrantLock();
        ArrayChannel arrayChannel2 = this;
        Object[] $this$buffer_u24lambda_u2d1 = objectArray = new Object[Math.min(arrayChannel2.capacity, 8)];
        arrayChannel = arrayChannel2;
        ArraysKt.fill$default((Object[])var2_3, (Object)AbstractChannelKt.EMPTY, (int)0, (int)0, (int)6, null);
        arrayChannel.buffer = objectArray;
        this.size = 0;
    }

    @Override
    protected final boolean isBufferAlwaysEmpty() {
        return false;
    }

    @Override
    protected final boolean isBufferEmpty() {
        return this.size == 0;
    }

    @Override
    protected final boolean isBufferAlwaysFull() {
        return false;
    }

    @Override
    protected final boolean isBufferFull() {
        return this.size == this.capacity && this.onBufferOverflow == BufferOverflow.SUSPEND;
    }

    @Override
    public boolean isEmpty() {
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            boolean bl = this.isEmptyImpl();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isClosedForReceive() {
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            boolean bl = super.isClosedForReceive();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object offerInternal(E element) {
        void var1_1;
        ReceiveOrClosed<E> receive;
        ReentrantLock reentrantLock = this.lock;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            int size = this.size;
            Closed<?> closed = this.getClosedForSend();
            if (closed != null) {
                element = closed;
                element = closed;
                return element;
            }
            Symbol symbol = this.updateBufferSize(size);
            if (symbol != null) {
                element = symbol;
                element = symbol;
                return element;
            }
            if (size == 0) {
                while (this.takeFirstReceiveOrPeekClosed() != null) {
                    if (receive instanceof Closed) {
                        this.size = size;
                        element = receive;
                        return element;
                    }
                    ReceiveOrClosed<E> receiveOrClosed = receive;
                    Intrinsics.checkNotNull(receiveOrClosed);
                    Symbol token = receiveOrClosed.tryResumeReceive(element, null);
                    if (token == null) continue;
                    if (DebugKt.getASSERTIONS_ENABLED() && !(token == CancellableContinuationImplKt.RESUME_TOKEN)) {
                        throw new AssertionError();
                    }
                    break;
                }
            } else {
                this.enqueueElement(size, element);
                element = AbstractChannelKt.OFFER_SUCCESS;
                return element;
            }
            this.size = size;
        }
        finally {
            lock.unlock();
        }
        receive.completeResumeReceive(var1_1);
        return reentrantLock.getOfferResult();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object offerSelectInternal(E element, SelectInstance<?> select) {
        void var2_3;
        void var1_1;
        Object receive;
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            AbstractSendChannel.TryOfferDesc<E> offerOp;
            int size;
            block14: {
                block15: {
                    size = this.size;
                    Closed<?> closed = this.getClosedForSend();
                    if (closed != null) {
                        element = closed;
                        element = closed;
                        return element;
                    }
                    Symbol symbol = this.updateBufferSize(size);
                    if (symbol != null) {
                        element = symbol;
                        element = symbol;
                        return element;
                    }
                    if (size == 0) {
                        Object failure;
                        do {
                            if ((failure = select.performAtomicTrySelect(offerOp = this.describeTryOffer(element))) == null) break block14;
                            if (failure == AbstractChannelKt.OFFER_FAILED) break block15;
                        } while (failure == AtomicKt.RETRY_ATOMIC);
                        if (failure == SelectKt.getALREADY_SELECTED() || failure instanceof Closed) {
                            this.size = size;
                            element = failure;
                            return element;
                        }
                        throw new IllegalStateException(("performAtomicTrySelect(describeTryOffer) returned " + failure).toString());
                    }
                }
                if (!receive.trySelect()) {
                    this.size = size;
                    element = SelectKt.getALREADY_SELECTED();
                    return element;
                }
                this.enqueueElement(size, element);
                element = AbstractChannelKt.OFFER_SUCCESS;
                return element;
            }
            this.size = size;
            receive = offerOp.getResult();
        }
        finally {
            lock.unlock();
        }
        Object t = receive;
        Intrinsics.checkNotNull(t);
        ((ReceiveOrClosed)t).completeResumeReceive(var1_1);
        return ((ReceiveOrClosed)var2_3).getOfferResult();
    }

    @Override
    protected Object enqueueSend(Send send) {
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            Object object;
            object = super.enqueueSend((Send)object);
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Symbol updateBufferSize(int currentSize) {
        if (currentSize < this.capacity) {
            void var1_1;
            this.size = var1_1 + true;
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.onBufferOverflow.ordinal()]) {
            case 1: {
                return AbstractChannelKt.OFFER_FAILED;
            }
            case 2: {
                return AbstractChannelKt.OFFER_SUCCESS;
            }
            case 3: {
                return null;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final void enqueueElement(int currentSize, E element) {
        void var2_2;
        if (currentSize < this.capacity) {
            this.ensureCapacity(currentSize);
            this.buffer[(this.head + currentSize) % this.buffer.length] = element;
            return;
        }
        if (DebugKt.getASSERTIONS_ENABLED() && !(this.onBufferOverflow == BufferOverflow.DROP_OLDEST)) {
            throw new AssertionError();
        }
        this.buffer[this.head % this.buffer.length] = null;
        this.buffer[(this.head + var1_1) % this.buffer.length] = var2_2;
        this.head = (this.head + 1) % this.buffer.length;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int currentSize) {
        if (currentSize >= this.buffer.length) {
            void var3_3;
            void var2_2;
            void var1_1;
            int newSize = Math.min(this.buffer.length << 1, this.capacity);
            Object[] newBuffer = new Object[newSize];
            for (int i = 0; i < currentSize; ++i) {
                newBuffer[i] = this.buffer[(this.head + i) % this.buffer.length];
            }
            ArraysKt.fill((Object[])newBuffer, (Object)AbstractChannelKt.EMPTY, (int)var1_1, (int)var2_2);
            this.buffer = var3_3;
            this.head = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object pollInternal() {
        void var2_3;
        Send send = null;
        boolean resumed = false;
        ReentrantLock reentrantLock = this.lock;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            int size = this.size;
            if (size == 0) {
                Closed<?> closed = this.getClosedForSend();
                if (closed == null) {
                    closed = AbstractChannelKt.POLL_FAILED;
                }
                send = closed;
                return send;
            }
            Object result2 = this.buffer[this.head];
            this.buffer[this.head] = null;
            this.size = size - 1;
            Object replacement = AbstractChannelKt.POLL_FAILED;
            if (size == this.capacity) {
                while (this.takeFirstSendOrPeekClosed() != null) {
                    Intrinsics.checkNotNull((Object)send);
                    Symbol token = send.tryResumeSend(null);
                    if (token != null) {
                        if (DebugKt.getASSERTIONS_ENABLED() && !(token == CancellableContinuationImplKt.RESUME_TOKEN)) {
                            throw new AssertionError();
                        }
                        resumed = true;
                        replacement = send.getPollResult();
                        break;
                    }
                    send.undeliveredElement();
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.buffer.length] = replacement;
            }
            this.head = (this.head + 1) % this.buffer.length;
        }
        finally {
            lock.unlock();
        }
        if (var2_3 != false) {
            void var1_1;
            void v1 = var1_1;
            Intrinsics.checkNotNull((Object)v1);
            v1.completeResumeSend();
        }
        return reentrantLock;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object pollSelectInternal(SelectInstance<?> select) {
        void var3_4;
        Object result2;
        Object send = null;
        boolean success = false;
        ReentrantLock reentrantLock = this.lock;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            Object object;
            Object replacement;
            int size;
            block18: {
                size = this.size;
                if (size == 0) {
                    Closed<?> closed = this.getClosedForSend();
                    if (closed == null) {
                        closed = AbstractChannelKt.POLL_FAILED;
                    }
                    select = closed;
                    return select;
                }
                result2 = this.buffer[this.head];
                this.buffer[this.head] = null;
                this.size = size - 1;
                replacement = AbstractChannelKt.POLL_FAILED;
                if (size == this.capacity) {
                    Object failure;
                    do {
                        AbstractChannel.TryPollDesc pollOp;
                        if ((failure = select.performAtomicTrySelect(pollOp = this.describeTryPoll())) == null) {
                            send = pollOp.getResult();
                            success = true;
                            Object object2 = send;
                            Intrinsics.checkNotNull(object2);
                            replacement = ((Send)object2).getPollResult();
                            break block18;
                        }
                        if (failure == AbstractChannelKt.POLL_FAILED) break block18;
                    } while (failure == AtomicKt.RETRY_ATOMIC);
                    if (failure == SelectKt.getALREADY_SELECTED()) {
                        this.size = size;
                        this.buffer[this.head] = result2;
                        select = failure;
                        return select;
                    }
                    if (failure instanceof Closed) {
                        send = failure;
                        success = true;
                        replacement = failure;
                    } else {
                        throw new IllegalStateException(("performAtomicTrySelect(describeTryOffer) returned " + failure).toString());
                    }
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.buffer.length] = replacement;
            } else if (!object.trySelect()) {
                this.size = size;
                this.buffer[this.head] = result2;
                object = SelectKt.getALREADY_SELECTED();
                return object;
            }
            this.head = (this.head + 1) % this.buffer.length;
        }
        finally {
            lock.unlock();
        }
        if (var3_4 != false) {
            void var2_3;
            void v2 = var2_3;
            Intrinsics.checkNotNull((Object)v2);
            ((Send)v2).completeResumeSend();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean enqueueReceiveInternal(Receive<? super E> receive) {
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            void var1_1;
            boolean bl = super.enqueueReceiveInternal(var1_1);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onCancelIdempotent(boolean wasClosed) {
        void var3_4;
        void var1_1;
        Function1 onUndeliveredElement = this.onUndeliveredElement;
        UndeliveredElementException undeliveredElementException = null;
        Lock lock = this.lock;
        lock = lock;
        lock.lock();
        try {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                Object value = this.buffer[this.head];
                if (onUndeliveredElement != null && value != AbstractChannelKt.EMPTY) {
                    undeliveredElementException = OnUndeliveredElementKt.callUndeliveredElementCatchingException(onUndeliveredElement, value, undeliveredElementException);
                }
                this.buffer[this.head] = AbstractChannelKt.EMPTY;
                this.head = (this.head + 1) % this.buffer.length;
            }
            this.size = 0;
        }
        finally {
            lock.unlock();
        }
        super.onCancelIdempotent((boolean)var1_1);
        lock = var3_4;
        if (lock != null) {
            throw lock;
        }
    }

    @Override
    protected String getBufferDebugString() {
        return "(buffer:capacity=" + this.capacity + ",size=" + this.size + ')';
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BufferOverflow.values().length];
            int[] nArray2 = nArray;
            nArray[BufferOverflow.SUSPEND.ordinal()] = 1;
            nArray2[BufferOverflow.DROP_LATEST.ordinal()] = 2;
            nArray2[BufferOverflow.DROP_OLDEST.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

