/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.AbstractMutableMap;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.debug.internal.ConcurrentWeakMap;
import kotlinx.coroutines.debug.internal.ConcurrentWeakMapKt;
import kotlinx.coroutines.debug.internal.HashedWeakRef;
import kotlinx.coroutines.debug.internal.Marked;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*:\u0003&'(B\u0011\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001a\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0014\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J#\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00028\u00002\b\u0010\u0013\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0019\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0012J\r\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u000eR&\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010#\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001c\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%\u00a8\u0006)"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;", "", "K", "V", "", "weakRefQueue", "<init>", "(Z)V", "Lkotlinx/coroutines/debug/internal/HashedWeakRef;", "w", "", "cleanWeakRef", "(Lkotlinx/coroutines/debug/internal/HashedWeakRef;)V", "clear", "()V", "decrementSize", "key", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "value", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putSynchronized", "remove", "runWeakRefQueueCleaningLoopUntilInterrupted", "", "", "getEntries", "()Ljava/util/Set;", "entries", "getKeys", "keys", "", "getSize", "()I", "size", "Ljava/lang/ref/ReferenceQueue;", "Ljava/lang/ref/ReferenceQueue;", "Core", "Entry", "KeyValueSet", "kotlinx-coroutines-core", "Lkotlin/collections/AbstractMutableMap;"})
public final class ConcurrentWeakMap<K, V>
extends AbstractMutableMap<K, V> {
    private volatile /* synthetic */ int _size;
    private static final /* synthetic */ AtomicIntegerFieldUpdater _size$FU;
    volatile /* synthetic */ Object core;
    private final ReferenceQueue<K> weakRefQueue;

    /*
     * WARNING - void declaration
     */
    public ConcurrentWeakMap(boolean weakRefQueue) {
        void var1_1;
        this._size = 0;
        this.core = new Core(this, 16);
        this.weakRefQueue = var1_1 != false ? new ReferenceQueue() : null;
    }

    public /* synthetic */ ConcurrentWeakMap(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final int getSize() {
        return this._size;
    }

    private final void decrementSize() {
        _size$FU.decrementAndGet(this);
    }

    /*
     * WARNING - void declaration
     */
    public final V get(Object key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        return ((Core)this.core).getImpl(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final V put(K key, V value) {
        void var3_3;
        Object oldValue = Core.putImpl$default((Core)this.core, key, value, null, 4, null);
        if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) {
            void var2_2;
            void var1_1;
            oldValue = this.putSynchronized(var1_1, var2_2);
        }
        if (oldValue == null) {
            _size$FU.incrementAndGet(this);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final V remove(Object key) {
        void var2_2;
        if (key == null) {
            return null;
        }
        Object oldValue = Core.putImpl$default((Core)this.core, key, null, null, 4, null);
        if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) {
            void var1_1;
            oldValue = this.putSynchronized(var1_1, null);
        }
        if (oldValue != null) {
            _size$FU.decrementAndGet(this);
        }
        return var2_2;
    }

    private final synchronized V putSynchronized(K key, V value) {
        Core curCore = (Core)this.core;
        Object oldValue;
        while ((oldValue = Core.putImpl$default(curCore, key, value, null, 4, null)) == ConcurrentWeakMapKt.access$getREHASH$p()) {
            curCore = curCore.rehash();
            this.core = curCore;
        }
        return (V)oldValue;
    }

    public final Set<K> getKeys() {
        return (Set)((Object)new KeyValueSet(this, keys.1.INSTANCE));
    }

    public final Set<Map.Entry<K, V>> getEntries() {
        return (Set)((Object)new KeyValueSet(this, entries.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        for (Object k : this.keySet()) {
            void var2_2;
            this.remove(var2_2);
        }
    }

    public final void runWeakRefQueueCleaningLoopUntilInterrupted() {
        if (!(this.weakRefQueue != null)) {
            String string = "Must be created with weakRefQueue = true";
            throw new IllegalStateException(string.toString());
        }
        try {
            while (true) {
                ConcurrentWeakMap concurrentWeakMap = this;
                Reference<K> reference = concurrentWeakMap.weakRefQueue.remove();
                if (reference == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlinx.coroutines.debug.internal.HashedWeakRef<*>");
                }
                concurrentWeakMap.cleanWeakRef((HashedWeakRef)reference);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanWeakRef(HashedWeakRef<?> w) {
        void var1_1;
        ((Core)this.core).cleanWeakRef((HashedWeakRef<?>)var1_1);
    }

    public ConcurrentWeakMap() {
        this(false, 1, null);
    }

    static {
        _size$FU = AtomicIntegerFieldUpdater.newUpdater(ConcurrentWeakMap.class, "_size");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u0018:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\b\u001a\u00020\u00072\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ3\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00020\u0013\"\u0004\b\u0002\u0010\u00102\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J3\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00028\u00002\b\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010 R\u0014\u0010!\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0014\u0010\"\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010 \u00a8\u0006$"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;", "", "allocated", "<init>", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;I)V", "Lkotlinx/coroutines/debug/internal/HashedWeakRef;", "weakRef", "", "cleanWeakRef", "(Lkotlinx/coroutines/debug/internal/HashedWeakRef;)V", "key", "getImpl", "(Ljava/lang/Object;)Ljava/lang/Object;", "hash", "index", "(I)I", "E", "Lkotlin/Function2;", "factory", "", "keyValueIterator", "(Lkotlin/jvm/functions/Function2;)Ljava/util/Iterator;", "value", "weakKey0", "", "putImpl", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlinx/coroutines/debug/internal/HashedWeakRef;)Ljava/lang/Object;", "Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;", "rehash", "()Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;", "removeCleanedAt", "(I)V", "I", "shift", "threshold", "KeyValueIterator", "kotlinx-coroutines-core"})
    private final class Core {
        private final int allocated;
        private final int shift;
        private final int threshold;
        private volatile /* synthetic */ int load;
        private static final /* synthetic */ AtomicIntegerFieldUpdater load$FU;
        /* synthetic */ AtomicReferenceArray keys;
        /* synthetic */ AtomicReferenceArray values;
        final /* synthetic */ ConcurrentWeakMap<K, V> this$0;

        /*
         * WARNING - void declaration
         */
        public Core(ConcurrentWeakMap this$0, int allocated) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.allocated = var2_2;
            this.shift = Integer.numberOfLeadingZeros(this.allocated) + 1;
            this.threshold = 2 * this.allocated / 3;
            this.load = 0;
            this.keys = new AtomicReferenceArray(this.allocated);
            this.values = new AtomicReferenceArray(this.allocated);
        }

        private final int index(int hash) {
            return hash * -1640531527 >>> this.shift;
        }

        /*
         * WARNING - void declaration
         */
        public final V getImpl(K key) {
            int index = this.index(key.hashCode());
            while ((HashedWeakRef)this.keys.get(index) != null) {
                HashedWeakRef hashedWeakRef;
                Object k = hashedWeakRef.get();
                if (Intrinsics.areEqual(key, k)) {
                    void var1_1;
                    Object value = this.values.get(index);
                    if (value instanceof Marked) {
                        return ((Marked)value).ref;
                    }
                    return var1_1;
                }
                if (hashedWeakRef == null) {
                    this.removeCleanedAt(index);
                }
                if (index == 0) {
                    index = this.allocated;
                }
                --index;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final void removeCleanedAt(int index) {
            void var2_2;
            do {
                Object oldValue;
                if (this.values.get(index) == null) {
                    return;
                }
                if (!(oldValue instanceof Marked)) continue;
                return;
            } while (!this.values.compareAndSet(index, var2_2, null));
            this.this$0.decrementSize();
        }

        public final Object putImpl(K key, V value, HashedWeakRef<K> weakKey0) {
            Object oldValue;
            int index = this.index(key.hashCode());
            boolean loadIncremented = false;
            while (true) {
                boolean bl;
                Core $this$update$iv;
                HashedWeakRef w;
                if ((w = (HashedWeakRef)this.keys.get(index)) == null) {
                    HashedWeakRef weakKey;
                    if (value == null) {
                        return null;
                    }
                    if (!loadIncremented) {
                        int n;
                        int upd$iv;
                        int cur$iv;
                        $this$update$iv = this;
                        do {
                            n = cur$iv = $this$update$iv.load;
                            if (cur$iv < this.threshold) continue;
                            return ConcurrentWeakMapKt.access$getREHASH$p();
                        } while (!load$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = n + 1));
                        bl = true;
                    }
                    if (weakKey == null) {
                        weakKey = new HashedWeakRef(key, this.this$0.weakRefQueue);
                    }
                    if (this.keys.compareAndSet(index, null, weakKey)) break;
                    continue;
                }
                Object k = ((Reference)((Object)$this$update$iv)).get();
                if (Intrinsics.areEqual(key, k)) {
                    if (!bl) break;
                    load$FU.decrementAndGet(this);
                    break;
                }
                if (k == null) {
                    this.removeCleanedAt(index);
                }
                if (index == 0) {
                    index = this.allocated;
                }
                --index;
            }
            do {
                if (!((oldValue = this.values.get(index)) instanceof Marked)) continue;
                return ConcurrentWeakMapKt.access$getREHASH$p();
            } while (!this.values.compareAndSet(index, oldValue, value));
            return oldValue;
        }

        public static /* synthetic */ Object putImpl$default(Core core, Object object, Object object2, HashedWeakRef hashedWeakRef, int n, Object object3) {
            if ((n & 4) != 0) {
                hashedWeakRef = null;
            }
            return core.putImpl(object, object2, hashedWeakRef);
        }

        /*
         * WARNING - void declaration
         */
        public final Core rehash() {
            void var1_1;
            block0: while (true) {
                int newCapacity = Integer.highestOneBit(RangesKt.coerceAtLeast((int)this.this$0.size(), (int)4)) << 2;
                Object newCore = new Core(this.this$0, newCapacity);
                int n = this.allocated;
                for (int index = 0; index < n; ++index) {
                    boolean bl;
                    Object value;
                    Object object;
                    Object k;
                    HashedWeakRef w = (HashedWeakRef)this.keys.get(index);
                    Object object2 = k = w != null ? w.get() : null;
                    if (w != null && k == null) {
                        this.removeCleanedAt(index);
                    }
                    do {
                        if ((value = this.values.get(index)) instanceof Marked) {
                            value = ((Marked)value).ref;
                            break;
                        }
                        object = value;
                    } while (!this.values.compareAndSet(index, object, ConcurrentWeakMapKt.access$mark(object)));
                    if (k == null || value == null) continue;
                    Object object3 = value;
                    Object oldValue = ((Core)newCore).putImpl(k, object3, w);
                    if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) continue block0;
                    boolean bl2 = bl = oldValue == null;
                    if (!_Assertions.ENABLED || bl) continue;
                    newCore = "Assertion failed";
                    throw new AssertionError(newCore);
                }
                break;
            }
            return var1_1;
        }

        public final void cleanWeakRef(HashedWeakRef<?> weakRef) {
            int index = this.index(weakRef.hash);
            while ((HashedWeakRef)this.keys.get(index) != null) {
                HashedWeakRef hashedWeakRef;
                if (hashedWeakRef == weakRef) {
                    this.removeCleanedAt(index);
                    return;
                }
                if (index == 0) {
                    index = this.allocated;
                }
                --index;
            }
            return;
        }

        /*
         * WARNING - void declaration
         */
        public final <E> Iterator<E> keyValueIterator(Function2<? super K, ? super V, ? extends E> factory) {
            void var1_1;
            return new KeyValueIterator(this, var1_1);
        }

        static {
            load$FU = AtomicIntegerFieldUpdater.newUpdater(Core.class, "load");
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u000e\u0010\u000f\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00028\u0001X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0013"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core$KeyValueIterator;", "E", "", "factory", "Lkotlin/Function2;", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;Lkotlin/jvm/functions/Function2;)V", "index", "", "key", "Ljava/lang/Object;", "value", "findNext", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "kotlinx-coroutines-core"})
        private final class KeyValueIterator<E>
        implements Iterator<E>,
        KMutableIterator {
            private final Function2<K, V, E> factory;
            private int index;
            private K key;
            private V value;
            final /* synthetic */ Core this$0;

            /*
             * WARNING - void declaration
             */
            public KeyValueIterator(Core this$0, Function2<? super K, ? super V, ? extends E> factory) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.factory = var2_2;
                this.index = -1;
                this.findNext();
            }

            /*
             * WARNING - void declaration
             */
            private final void findNext() {
                block2: {
                    void var1_1;
                    while (true) {
                        ++this.index;
                        if (this.index >= this.this$0.allocated) break block2;
                        HashedWeakRef hashedWeakRef = (HashedWeakRef)this.this$0.keys.get(this.index);
                        if (hashedWeakRef == null || (hashedWeakRef = hashedWeakRef.get()) == null) continue;
                        this.key = hashedWeakRef;
                        Object value = this.this$0.values.get(this.index);
                        if (value instanceof Marked) {
                            value = ((Marked)value).ref;
                        }
                        if (value != null) break;
                    }
                    this.value = var1_1;
                    return;
                }
            }

            @Override
            public final boolean hasNext() {
                return this.index < this.this$0.allocated;
            }

            @Override
            public final E next() {
                Object object;
                if (this.index >= this.this$0.allocated) {
                    throw new NoSuchElementException();
                }
                Object object2 = this.key;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"key");
                    object2 = Unit.INSTANCE;
                }
                if ((object = this.value) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"value");
                    object = Unit.INSTANCE;
                }
                Object object3 = this.factory.invoke(object2, object);
                this.findNext();
                return (E)object3;
            }

            public final Void remove() {
                ConcurrentWeakMapKt.access$noImpl();
                throw new KotlinNothingValueException();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00028\u00032\u0006\u0010\f\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\rR\u0016\u0010\u0004\u001a\u00028\u0002X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Entry;", "K", "V", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "setValue", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "kotlinx-coroutines-core"})
    private static final class Entry<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        private final K key;
        private final V value;

        /*
         * WARNING - void declaration
         */
        public Entry(K key, V value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            ConcurrentWeakMapKt.access$noImpl();
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u000fH\u0096\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$KeyValueSet;", "E", "Lkotlin/collections/AbstractMutableSet;", "factory", "Lkotlin/Function2;", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;Lkotlin/jvm/functions/Function2;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "iterator", "", "kotlinx-coroutines-core"})
    private final class KeyValueSet<E>
    extends AbstractMutableSet<E> {
        private final Function2<K, V, E> factory;
        final /* synthetic */ ConcurrentWeakMap<K, V> this$0;

        /*
         * WARNING - void declaration
         */
        public KeyValueSet(ConcurrentWeakMap this$0, Function2<? super K, ? super V, ? extends E> factory) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.factory = var2_2;
        }

        public final int getSize() {
            return this.this$0.size();
        }

        public final boolean add(E element) {
            ConcurrentWeakMapKt.access$noImpl();
            throw new KotlinNothingValueException();
        }

        public final Iterator<E> iterator() {
            return ((Core)this.this$0.core).keyValueIterator(this.factory);
        }
    }
}

